/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.XAConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang.UnhandledException;
import org.mule.MuleManager;
import org.mule.MuleRuntimeException;
import org.mule.config.ExceptionHelper;
import org.mule.config.ExceptionReader;
import org.mule.config.i18n.Message;
import org.mule.impl.internal.notifications.ConnectionNotificationListener;
import org.mule.impl.internal.notifications.NotificationException;
import org.mule.providers.AbstractServiceEnabledConnector;
import org.mule.providers.ConnectException;
import org.mule.providers.ConnectionStrategy;
import org.mule.providers.FatalConnectException;
import org.mule.providers.ReplyToHandler;
import org.mule.providers.jms.DefaultRedeliveryHandler;
import org.mule.providers.jms.Jms102bSupport;
import org.mule.providers.jms.Jms11Support;
import org.mule.providers.jms.JmsClientAcknowledgeTransactionFactory;
import org.mule.providers.jms.JmsExceptionReader;
import org.mule.providers.jms.JmsReplyToHandler;
import org.mule.providers.jms.JmsSupport;
import org.mule.providers.jms.RedeliveryHandler;
import org.mule.providers.jms.xa.ConnectionFactoryWrapper;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.TransactionException;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.LifecycleException;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.manager.UMOServerNotificationListener;
import org.mule.umo.provider.UMOConnectable;
import org.mule.util.BeanUtils;
import org.mule.util.ClassUtils;

public class JmsConnector
extends AbstractServiceEnabledConnector
implements ConnectionNotificationListener {
    private String connectionFactoryJndiName;
    private ConnectionFactory connectionFactory;
    private String connectionFactoryClass;
    private String jndiInitialFactory;
    private String jndiProviderUrl;
    private int acknowledgementMode = 1;
    private String clientId;
    private boolean durable;
    private boolean noLocal;
    private boolean persistentDelivery;
    private Map jndiProviderProperties;
    private Map connectionFactoryProperties;
    private Connection connection;
    private String specification = "1.0.2b";
    private JmsSupport jmsSupport;
    private Context jndiContext;
    private boolean jndiDestinations = false;
    private boolean forceJndiDestinations = false;
    public String username = null;
    public String password = null;
    private int maxRedelivery = 0;
    private String redeliveryHandler = DefaultRedeliveryHandler.class.getName();
    private boolean cacheJmsSessions = false;
    private boolean recoverJmsConnections = true;

    public JmsConnector() {
        this.receivers = new ConcurrentHashMap();
    }

    public void doInitialise() throws InitialisationException {
        if (this.dispatchers == null) {
            this.dispatchers = new ConcurrentHashMap();
        }
        if (this.receivers == null) {
            this.receivers = new ConcurrentHashMap();
        }
        super.doInitialise();
        try {
            MuleManager.getInstance().registerListener((UMOServerNotificationListener)this, this.getName());
        }
        catch (NotificationException nex) {
            throw new InitialisationException((Throwable)nex, (Object)this);
        }
    }

    protected void initJndiContext() throws NamingException, InitialisationException {
        if (this.jndiContext == null) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            if (this.jndiInitialFactory != null) {
                props.put("java.naming.factory.initial", this.jndiInitialFactory);
            } else if (this.jndiProviderProperties == null || !this.jndiProviderProperties.containsKey("java.naming.factory.initial")) {
                throw new InitialisationException(new Message(45, (Object)"jndiInitialFactory"), (Object)this);
            }
            if (this.jndiProviderUrl != null) {
                props.put("java.naming.provider.url", this.jndiProviderUrl);
            }
            if (this.jndiProviderProperties != null) {
                props.putAll(this.jndiProviderProperties);
            }
            this.jndiContext = new InitialContext(props);
        }
    }

    protected void setConnection(Connection connection) {
        this.connection = connection;
    }

    protected ConnectionFactory createConnectionFactory() throws InitialisationException, NamingException {
        Object temp = this.jndiContext.lookup(this.connectionFactoryJndiName);
        if (temp instanceof ConnectionFactory) {
            return (ConnectionFactory)temp;
        }
        throw new InitialisationException(new Message(121, (Object)this.connectionFactoryJndiName), (Object)this);
    }

    protected Connection createConnection() throws NamingException, JMSException, InitialisationException {
        if (this.connectionFactory == null) {
            this.connectionFactory = this.createConnectionFactory();
        }
        if (this.connectionFactory != null && this.connectionFactory instanceof XAConnectionFactory && MuleManager.getInstance().getTransactionManager() != null) {
            this.connectionFactory = new ConnectionFactoryWrapper(this.connectionFactory, MuleManager.getInstance().getTransactionManager());
        }
        Connection connection = this.username != null ? this.jmsSupport.createConnection(this.connectionFactory, this.username, this.password) : this.jmsSupport.createConnection(this.connectionFactory);
        if (this.clientId != null) {
            connection.setClientID(this.getClientId());
        }
        final ConnectionStrategy connectionStrategy = this.getConnectionStrategy();
        if (this.recoverJmsConnections && connectionStrategy != null && connection != null) {
            connection.setExceptionListener(new ExceptionListener(){

                public void onException(JMSException jmsException) {
                    JmsConnector.this.logger.debug((Object)"About to recycle myself due to remote JMS connection shutdown.");
                    JmsConnector jmsConnector = JmsConnector.this;
                    try {
                        jmsConnector.stopConnector();
                        jmsConnector.initialised.set(false);
                    }
                    catch (UMOException e) {
                        JmsConnector.this.logger.warn((Object)e.getMessage(), (Throwable)e);
                    }
                    try {
                        connectionStrategy.connect((UMOConnectable)jmsConnector);
                        jmsConnector.initialise();
                        jmsConnector.startConnector();
                    }
                    catch (FatalConnectException fcex) {
                        JmsConnector.this.logger.fatal((Object)"Failed to reconnect to JMS server. I'm giving up.");
                    }
                    catch (UMOException umoex) {
                        throw new UnhandledException("Failed to recover a connector.", (Throwable)umoex);
                    }
                }
            });
        }
        return connection;
    }

    public void doConnect() throws ConnectException {
        try {
            if (this.connectionFactoryClass != null) {
                this.connectionFactory = (ConnectionFactory)ClassUtils.instanciateClass((String)this.connectionFactoryClass, (Object[])ClassUtils.NO_ARGS);
            }
            if (this.connectionFactory == null || this.jndiInitialFactory != null) {
                this.initJndiContext();
            } else {
                this.jndiDestinations = false;
                this.forceJndiDestinations = false;
            }
            if (this.jmsSupport == null) {
                this.jmsSupport = "1.0.2b".equals(this.specification) ? new Jms102bSupport(this, this.jndiContext, this.jndiDestinations, this.forceJndiDestinations) : new Jms11Support(this, this.jndiContext, this.jndiDestinations, this.forceJndiDestinations);
            }
            if (this.connectionFactory == null) {
                this.connectionFactory = this.createConnectionFactory();
            }
            if (this.connectionFactoryProperties != null && !this.connectionFactoryProperties.isEmpty()) {
                BeanUtils.populateWithoutFail((Object)this.connectionFactory, (Map)this.connectionFactoryProperties, (boolean)true);
            }
        }
        catch (Exception e) {
            throw new ConnectException(new Message(65, (Object)"Jms Connector"), (Throwable)e, (Object)this);
        }
        try {
            this.connection = this.createConnection();
            if (this.started.get()) {
                this.connection.start();
            }
        }
        catch (Exception e) {
            throw new ConnectException((Throwable)e, (Object)this);
        }
    }

    public void doDisconnect() throws ConnectException {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception e) {
            throw new ConnectException((Throwable)e, (Object)this);
        }
        finally {
            this.connection = null;
        }
    }

    protected Object getReceiverKey(UMOComponent component, UMOEndpoint endpoint) {
        return component.getDescriptor().getName() + "~" + endpoint.getEndpointURI().getAddress();
    }

    public Object getSessionFactory(UMOEndpoint endpoint) {
        if (endpoint.getTransactionConfig() != null && endpoint.getTransactionConfig().getFactory() instanceof JmsClientAcknowledgeTransactionFactory) {
            throw new MuleRuntimeException(new Message("jms", 9));
        }
        return this.connection;
    }

    public Session getSessionFromTransaction() {
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        if (tx != null && tx.hasResource((Object)this.connection)) {
            return (Session)tx.getResource((Object)this.connection);
        }
        return null;
    }

    public Session getSession(boolean transacted, boolean topic) throws JMSException {
        if (!this.isConnected()) {
            throw new JMSException("Not connected");
        }
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        Session session = this.getSessionFromTransaction();
        if (session != null) {
            this.logger.debug((Object)"Retrieving jms session from current transaction");
            return session;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Retrieving new jms session from connection: topic=" + topic + ", transacted=" + (transacted || tx != null) + ", ack mode=" + this.acknowledgementMode + ", nolocal=" + this.noLocal));
        }
        session = this.jmsSupport.createSession(this.connection, topic, transacted || tx != null, this.acknowledgementMode, this.noLocal);
        if (tx != null) {
            this.logger.debug((Object)"Binding session to current transaction");
            try {
                tx.bindResource((Object)this.connection, (Object)session);
            }
            catch (TransactionException e) {
                throw new RuntimeException("Could not bind session to current transaction", e);
            }
        }
        return session;
    }

    public void doStart() throws UMOException {
        if (this.connection != null) {
            try {
                this.connection.start();
            }
            catch (JMSException e) {
                throw new LifecycleException(new Message(42, (Object)"Jms Connection"), (Object)e);
            }
        }
    }

    public String getProtocol() {
        return "jms";
    }

    protected void doDispose() {
        super.doDispose();
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                this.logger.error((Object)"Jms connector failed to dispose properly: ", (Throwable)e);
            }
            this.connection = null;
        }
        if (this.jndiContext != null) {
            try {
                this.jndiContext.close();
            }
            catch (NamingException e) {
                this.logger.error((Object)"Jms connector failed to dispose properly: ", (Throwable)e);
            }
            this.jndiContext = null;
        }
    }

    public int getAcknowledgementMode() {
        return this.acknowledgementMode;
    }

    public void setAcknowledgementMode(int acknowledgementMode) {
        this.acknowledgementMode = acknowledgementMode;
    }

    public String getConnectionFactoryJndiName() {
        return this.connectionFactoryJndiName;
    }

    public void setConnectionFactoryJndiName(String connectionFactoryJndiName) {
        this.connectionFactoryJndiName = connectionFactoryJndiName;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public boolean isPersistentDelivery() {
        return this.persistentDelivery;
    }

    public void setPersistentDelivery(boolean persistentDelivery) {
        this.persistentDelivery = persistentDelivery;
    }

    public Map getJndiProviderProperties() {
        return this.jndiProviderProperties;
    }

    public void setJndiProviderProperties(Map jndiProviderProperties) {
        this.jndiProviderProperties = jndiProviderProperties;
    }

    public Map getConnectionFactoryProperties() {
        return this.connectionFactoryProperties;
    }

    public void setConnectionFactoryProperties(Map connectionFactoryProperties) {
        this.connectionFactoryProperties = connectionFactoryProperties;
    }

    public String getJndiInitialFactory() {
        return this.jndiInitialFactory;
    }

    public void setJndiInitialFactory(String jndiInitialFactory) {
        this.jndiInitialFactory = jndiInitialFactory;
    }

    public String getJndiProviderUrl() {
        return this.jndiProviderUrl;
    }

    public void setJndiProviderUrl(String jndiProviderUrl) {
        this.jndiProviderUrl = jndiProviderUrl;
    }

    public Session getSession(UMOImmutableEndpoint endpoint) throws Exception {
        String resourceInfo = endpoint.getEndpointURI().getResourceInfo();
        boolean topic = resourceInfo != null && "topic".equalsIgnoreCase(resourceInfo);
        return this.getSession(endpoint.getTransactionConfig().isTransacted(), topic);
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getConnectionFactoryClass() {
        return this.connectionFactoryClass;
    }

    public void setConnectionFactoryClass(String connectionFactoryClass) {
        this.connectionFactoryClass = connectionFactoryClass;
    }

    public JmsSupport getJmsSupport() {
        return this.jmsSupport;
    }

    public void setJmsSupport(JmsSupport jmsSupport) {
        this.jmsSupport = jmsSupport;
    }

    public String getSpecification() {
        return this.specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    public boolean isJndiDestinations() {
        return this.jndiDestinations;
    }

    public void setJndiDestinations(boolean jndiDestinations) {
        this.jndiDestinations = jndiDestinations;
    }

    public boolean isForceJndiDestinations() {
        return this.forceJndiDestinations;
    }

    public void setForceJndiDestinations(boolean forceJndiDestinations) {
        this.forceJndiDestinations = forceJndiDestinations;
    }

    public Context getJndiContext() {
        return this.jndiContext;
    }

    public void setJndiContext(Context jndiContext) {
        this.jndiContext = jndiContext;
    }

    public void setRecoverJmsConnections(boolean recover) {
        this.recoverJmsConnections = recover;
    }

    public boolean isRecoverJmsConnections() {
        return this.recoverJmsConnections;
    }

    protected RedeliveryHandler createRedeliveryHandler() throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        if (this.redeliveryHandler != null) {
            return (RedeliveryHandler)ClassUtils.instanciateClass((String)this.redeliveryHandler, (Object[])ClassUtils.NO_ARGS);
        }
        return new DefaultRedeliveryHandler();
    }

    public ReplyToHandler getReplyToHandler() {
        return new JmsReplyToHandler(this, this.defaultResponseTransformer);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public int getMaxRedelivery() {
        return this.maxRedelivery;
    }

    public void setMaxRedelivery(int maxRedelivery) {
        this.maxRedelivery = maxRedelivery;
    }

    public String getRedeliveryHandler() {
        return this.redeliveryHandler;
    }

    public void setRedeliveryHandler(String redeliveryHandler) {
        this.redeliveryHandler = redeliveryHandler;
    }

    public boolean isRemoteSyncEnabled() {
        return true;
    }

    public void onNotification(UMOServerNotification notification) {
        if (notification.getAction() == 703 || notification.getAction() == 702) {
            this.disposeDispatchers();
        }
    }

    public boolean isCacheJmsSessions() {
        return this.cacheJmsSessions;
    }

    public void setCacheJmsSessions(boolean cacheJmsSessions) {
        this.cacheJmsSessions = cacheJmsSessions;
    }

    public boolean supportsProperty(String property) {
        return true;
    }

    public javax.jms.Message preProcessMessage(javax.jms.Message message, Session session) throws Exception {
        return message;
    }

    public void close(MessageProducer producer) throws JMSException {
        if (producer != null) {
            producer.close();
        }
    }

    public void closeQuietly(MessageProducer producer) {
        try {
            this.close(producer);
        }
        catch (JMSException e) {
            this.logger.error((Object)"Failed to close jms message producer", (Throwable)e);
        }
    }

    public void close(MessageConsumer consumer) throws JMSException {
        if (consumer != null) {
            consumer.close();
        }
    }

    public void closeQuietly(MessageConsumer consumer) {
        try {
            this.close(consumer);
        }
        catch (JMSException e) {
            this.logger.error((Object)"Failed to close jms message consumer", (Throwable)e);
        }
    }

    public void close(Session session) throws JMSException {
        if (session != null) {
            session.close();
        }
    }

    public void closeQuietly(Session session) {
        try {
            this.close(session);
        }
        catch (JMSException e) {
            this.logger.error((Object)"Failed to close jms session consumer", (Throwable)e);
        }
    }

    public void close(TemporaryQueue tempQueue) throws JMSException {
        if (tempQueue != null) {
            tempQueue.delete();
        }
    }

    public void closeQuietly(TemporaryQueue tempQueue) {
        block4: {
            try {
                this.close(tempQueue);
            }
            catch (JMSException e) {
                if (!this.logger.isErrorEnabled()) break block4;
                String queueName = "";
                try {
                    queueName = tempQueue.getQueueName();
                }
                catch (JMSException innerEx) {
                    // empty catch block
                }
                this.logger.error((Object)("Faled to delete a temporary queue " + queueName), (Throwable)e);
            }
        }
    }

    public void close(TemporaryTopic tempTopic) throws JMSException {
        if (tempTopic != null) {
            tempTopic.delete();
        }
    }

    public void closeQuietly(TemporaryTopic tempTopic) {
        block4: {
            try {
                this.close(tempTopic);
            }
            catch (JMSException e) {
                if (!this.logger.isErrorEnabled()) break block4;
                String topicName = "";
                try {
                    topicName = tempTopic.getTopicName();
                }
                catch (JMSException innerEx) {
                    // empty catch block
                }
                this.logger.error((Object)("Faled to delete a temporary topic " + topicName), (Throwable)e);
            }
        }
    }

    static {
        ExceptionHelper.registerExceptionReader((ExceptionReader)new JmsExceptionReader());
    }
}

