/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.providers.jms.JmsMessageUtils;
import org.mule.umo.MessagingException;
import org.mule.umo.provider.MessageTypeNotSupportedException;

public class JmsMessageAdapter
extends AbstractMessageAdapter {
    private static final long serialVersionUID = -5979930419887129835L;
    private Message message = null;

    public JmsMessageAdapter(Object message) throws MessagingException {
        this.setMessage(message);
    }

    public String getPayloadAsString(String encoding) throws Exception {
        return new String(this.getPayloadAsBytes(), encoding);
    }

    public byte[] getPayloadAsBytes() throws Exception {
        return JmsMessageUtils.getBytesFromMessage(this.message);
    }

    public Object getPayload() {
        return this.message;
    }

    private void setMessage(Object message) throws MessagingException {
        if (!(message instanceof Message)) {
            throw new MessageTypeNotSupportedException(message, ((Object)((Object)this)).getClass());
        }
        this.message = (Message)message;
        try {
            String value = this.message.getJMSCorrelationID();
            if (value != null) {
                this.setProperty("JMSCorrelationID", value);
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            int value = this.message.getJMSDeliveryMode();
            this.setProperty("JMSDeliveryMode", new Integer(value));
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            Destination value = this.message.getJMSDestination();
            if (value != null) {
                this.setProperty("JMSDestination", value);
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            long value = this.message.getJMSExpiration();
            this.setProperty("JMSExpiration", new Long(value));
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            String value = this.message.getJMSMessageID();
            if (value != null) {
                this.setProperty("JMSMessageID", value);
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            int value = this.message.getJMSPriority();
            this.setProperty("JMSPriority", new Integer(value));
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            boolean value = this.message.getJMSRedelivered();
            this.setProperty("JMSRedelivered", value);
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            Destination value = this.message.getJMSReplyTo();
            if (value != null) {
                this.setProperty("JMSReplyTo", value);
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            long value = this.message.getJMSTimestamp();
            this.setProperty("JMSTimestamp", new Long(value));
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            String value = this.message.getJMSType();
            if (value != null) {
                this.setProperty("JMSType", value);
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            Enumeration e = this.message.getPropertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                try {
                    Object value = this.message.getObjectProperty(key);
                    if (value == null) continue;
                    this.setProperty(key, value);
                }
                catch (JMSException e1) {}
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public String getUniqueId() {
        return (String)this.getProperty("JMSMessageID");
    }

    public void setCorrelationId(String id) {
        this.setProperty("JMSCorrelationID", id);
    }

    public String getCorrelationId() {
        return (String)this.getProperty("JMSCorrelationID");
    }

    public void setReplyTo(Object replyTo) {
        if (replyTo instanceof Destination) {
            this.setProperty("JMSReplyTo", replyTo);
        } else {
            super.setReplyTo(replyTo);
        }
    }

    public Object getReplyTo() {
        Object replyTo = this.getProperty("JMSReplyTo");
        if (replyTo == null) {
            replyTo = this.getProperty("MULE_REPLYTO");
        }
        return replyTo;
    }
}

