/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import org.apache.commons.collections.MapUtils;
import org.mule.MuleException;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.JmsMessageUtils;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.util.concurrent.Latch;
import org.mule.util.concurrent.WaitableBoolean;

public class JmsMessageDispatcher
extends AbstractMessageDispatcher {
    private JmsConnector connector;
    private Session delegateSession;
    private Session cachedSession;

    public JmsMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (JmsConnector)endpoint.getConnector();
    }

    protected void doDispatch(UMOEvent event) throws Exception {
        this.dispatchMessage(event);
    }

    protected void doConnect(UMOImmutableEndpoint endpoint) throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UMOMessage dispatchMessage(UMOEvent event) throws Exception {
        boolean cached;
        boolean transacted;
        Destination replyTo;
        MessageConsumer consumer;
        MessageProducer producer;
        Session session;
        block54: {
            javax.jms.Message result;
            block55: {
                boolean persistent;
                int priority;
                long ttl;
                javax.jms.Message msg;
                boolean topic;
                block52: {
                    javax.jms.Message result2;
                    block53: {
                        UMOMessage uMOMessage;
                        session = null;
                        producer = null;
                        consumer = null;
                        replyTo = null;
                        transacted = false;
                        cached = false;
                        boolean remoteSync = this.useRemoteSync(event);
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("dispatching on endpoint: " + event.getEndpoint().getEndpointURI() + ". Event id is: " + event.getId()));
                        }
                        try {
                            session = this.connector.getSessionFromTransaction();
                            if (session != null) {
                                transacted = true;
                                if (remoteSync) {
                                    throw new IllegalTransactionStateException(new Message("jms", 2));
                                }
                            } else if (event.getMessage().getBooleanProperty("cacheJmsSessions", this.connector.isCacheJmsSessions())) {
                                cached = true;
                                if (this.cachedSession != null) {
                                    session = this.cachedSession;
                                } else {
                                    this.cachedSession = session = this.connector.getSession(event.getEndpoint());
                                }
                            } else {
                                session = this.connector.getSession(event.getEndpoint());
                                if (event.getEndpoint().getTransactionConfig().isTransacted()) {
                                    transacted = true;
                                }
                            }
                            UMOEndpointURI endpointUri = event.getEndpoint().getEndpointURI();
                            topic = false;
                            String resourceInfo = endpointUri.getResourceInfo();
                            boolean bl = topic = resourceInfo != null && "topic".equalsIgnoreCase(resourceInfo);
                            if (!topic) {
                                topic = MapUtils.getBooleanValue((Map)event.getEndpoint().getProperties(), (Object)"topic", (boolean)false);
                            }
                            Destination dest = this.connector.getJmsSupport().createDestination(session, endpointUri.getAddress(), topic);
                            producer = this.connector.getJmsSupport().createProducer(session, dest, topic);
                            Object message = event.getTransformedMessage();
                            if (!(message instanceof javax.jms.Message)) {
                                throw new DispatchException(new Message(125, (Object)"JMS message", (Object)message.getClass().getName(), (Object)this.connector.getName()), event.getMessage(), event.getEndpoint());
                            }
                            msg = (javax.jms.Message)message;
                            if (event.getMessage().getCorrelationId() != null) {
                                msg.setJMSCorrelationID(event.getMessage().getCorrelationId());
                            }
                            UMOMessage eventMsg = event.getMessage();
                            if (this.connector.supportsProperty("JMSReplyTo")) {
                                Object tempReplyTo = eventMsg.removeProperty("JMSReplyTo");
                                if (tempReplyTo != null) {
                                    if (tempReplyTo instanceof Destination) {
                                        replyTo = (Destination)tempReplyTo;
                                    } else {
                                        boolean replyToTopic = false;
                                        String reply = tempReplyTo.toString();
                                        int i = reply.indexOf(":");
                                        if (i > -1) {
                                            String qtype = reply.substring(0, i);
                                            replyToTopic = "topic".equalsIgnoreCase(qtype);
                                            reply = reply.substring(i + 1);
                                        }
                                        replyTo = this.connector.getJmsSupport().createDestination(session, reply, replyToTopic);
                                    }
                                }
                                if (remoteSync && replyTo == null) {
                                    replyTo = this.connector.getJmsSupport().createTemporaryDestination(session, topic);
                                }
                                if (replyTo != null) {
                                    msg.setJMSReplyTo(replyTo);
                                }
                                if (remoteSync) {
                                    consumer = this.connector.getJmsSupport().createConsumer(session, replyTo, topic);
                                }
                            }
                            String ttlString = (String)eventMsg.removeProperty("timeToLive");
                            String priorityString = (String)eventMsg.removeProperty("priority");
                            String persistentDeliveryString = (String)eventMsg.removeProperty("persistentDelivery");
                            ttl = 0L;
                            priority = 4;
                            persistent = true;
                            if (ttlString != null) {
                                ttl = Long.parseLong(ttlString);
                            }
                            if (priorityString != null) {
                                priority = Integer.parseInt(priorityString);
                            }
                            if (persistentDeliveryString != null) {
                                persistent = Boolean.valueOf(persistentDeliveryString);
                            }
                            this.logger.debug((Object)("Sending message of type " + msg.getClass().getName()));
                            if (consumer == null || !topic) break block52;
                            Latch l = new Latch();
                            ReplyToListener listener = new ReplyToListener(l);
                            consumer.setMessageListener((MessageListener)listener);
                            this.connector.getJmsSupport().send(producer, msg, persistent, priority, ttl, topic);
                            int timeout2 = event.getTimeout();
                            this.logger.debug((Object)("Waiting for return event for: " + timeout2 + " ms on " + replyTo));
                            l.await((long)timeout2, TimeUnit.MILLISECONDS);
                            consumer.setMessageListener(null);
                            listener.release();
                            result2 = listener.getMessage();
                            if (result2 != null) break block53;
                            this.logger.debug((Object)"No message was returned via replyTo destination");
                            uMOMessage = null;
                            Object var30_37 = null;
                            this.connector.closeQuietly(consumer);
                            this.connector.closeQuietly(producer);
                        }
                        catch (Throwable throwable) {
                            block56: {
                                Object var30_42 = null;
                                this.connector.closeQuietly(consumer);
                                this.connector.closeQuietly(producer);
                                if (replyTo != null && (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic)) {
                                    if (replyTo instanceof TemporaryQueue) {
                                        this.connector.closeQuietly((TemporaryQueue)replyTo);
                                    } else {
                                        this.connector.closeQuietly((TemporaryTopic)replyTo);
                                    }
                                }
                                if (session == null || cached || transacted) break block56;
                                this.connector.closeQuietly(session);
                            }
                            throw throwable;
                        }
                        if (replyTo != null && (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic)) {
                            if (replyTo instanceof TemporaryQueue) {
                                this.connector.closeQuietly((TemporaryQueue)replyTo);
                            } else {
                                this.connector.closeQuietly((TemporaryTopic)replyTo);
                            }
                        }
                        if (session != null && !cached && !transacted) {
                            this.connector.closeQuietly(session);
                        }
                        return uMOMessage;
                    }
                    UMOMessageAdapter adapter = this.connector.getMessageAdapter(result2);
                    MuleMessage muleMessage = new MuleMessage(JmsMessageUtils.getObjectForMessage(result2), adapter);
                    Object var30_38 = null;
                    this.connector.closeQuietly(consumer);
                    this.connector.closeQuietly(producer);
                    if (replyTo != null && (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic)) {
                        if (replyTo instanceof TemporaryQueue) {
                            this.connector.closeQuietly((TemporaryQueue)replyTo);
                        } else {
                            this.connector.closeQuietly((TemporaryTopic)replyTo);
                        }
                    }
                    if (session != null && !cached && !transacted) {
                        this.connector.closeQuietly(session);
                    }
                    return muleMessage;
                }
                this.connector.getJmsSupport().send(producer, msg, persistent, priority, ttl, topic);
                if (consumer == null) break block54;
                int timeout = event.getTimeout();
                this.logger.debug((Object)("Waiting for return event for: " + timeout + " ms on " + replyTo));
                result = consumer.receive((long)timeout);
                if (result != null) break block55;
                this.logger.debug((Object)"No message was returned via replyTo destination");
                UMOMessage timeout2 = null;
                Object var30_39 = null;
                this.connector.closeQuietly(consumer);
                this.connector.closeQuietly(producer);
                if (replyTo != null && (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic)) {
                    if (replyTo instanceof TemporaryQueue) {
                        this.connector.closeQuietly((TemporaryQueue)replyTo);
                    } else {
                        this.connector.closeQuietly((TemporaryTopic)replyTo);
                    }
                }
                if (session != null && !cached && !transacted) {
                    this.connector.closeQuietly(session);
                }
                return timeout2;
            }
            UMOMessageAdapter adapter = this.connector.getMessageAdapter(result);
            MuleMessage muleMessage = new MuleMessage(JmsMessageUtils.getObjectForMessage(result), adapter);
            Object var30_40 = null;
            this.connector.closeQuietly(consumer);
            this.connector.closeQuietly(producer);
            if (replyTo != null && (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic)) {
                if (replyTo instanceof TemporaryQueue) {
                    this.connector.closeQuietly((TemporaryQueue)replyTo);
                } else {
                    this.connector.closeQuietly((TemporaryTopic)replyTo);
                }
            }
            if (session != null && !cached && !transacted) {
                this.connector.closeQuietly(session);
            }
            return muleMessage;
        }
        UMOMessage uMOMessage = null;
        Object var30_41 = null;
        this.connector.closeQuietly(consumer);
        this.connector.closeQuietly(producer);
        if (replyTo != null && (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic)) {
            if (replyTo instanceof TemporaryQueue) {
                this.connector.closeQuietly((TemporaryQueue)replyTo);
            } else {
                this.connector.closeQuietly((TemporaryTopic)replyTo);
            }
        }
        if (session != null && !cached && !transacted) {
            this.connector.closeQuietly(session);
        }
        return uMOMessage;
    }

    protected UMOMessage doSend(UMOEvent event) throws Exception {
        UMOMessage message = this.dispatchMessage(event);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected UMOMessage doReceive(UMOImmutableEndpoint endpoint, long timeout) throws Exception {
        javax.jms.Message message;
        MessageConsumer consumer;
        Session session;
        block6: {
            session = null;
            Destination dest = null;
            consumer = null;
            boolean topic = false;
            String resourceInfo = endpoint.getEndpointURI().getResourceInfo();
            topic = resourceInfo != null && "topic".equalsIgnoreCase(resourceInfo);
            session = this.connector.getSession(false, topic);
            dest = this.connector.getJmsSupport().createDestination(session, endpoint.getEndpointURI().getAddress(), topic);
            consumer = this.connector.getJmsSupport().createConsumer(session, dest, topic);
            message = null;
            message = timeout == -1L ? consumer.receiveNoWait() : (timeout == 0L ? consumer.receive() : consumer.receive(timeout));
            if (message != null) break block6;
            UMOMessage uMOMessage = null;
            this.connector.closeQuietly(consumer);
            this.connector.closeQuietly(session);
            return uMOMessage;
        }
        message = this.connector.preProcessMessage(message, session);
        MuleMessage muleMessage = new MuleMessage((Object)this.connector.getMessageAdapter(message));
        this.connector.closeQuietly(consumer);
        this.connector.closeQuietly(session);
        return muleMessage;
        {
            catch (Exception e) {
                try {
                    this.connector.handleException(e);
                    UMOMessage uMOMessage = null;
                    this.connector.closeQuietly(consumer);
                    this.connector.closeQuietly(session);
                    return uMOMessage;
                }
                catch (Throwable throwable) {
                    this.connector.closeQuietly(consumer);
                    this.connector.closeQuietly(session);
                    throw throwable;
                }
            }
        }
    }

    public synchronized Object getDelegateSession() throws UMOException {
        try {
            Session session = this.connector.getSessionFromTransaction();
            if (session != null) {
                return session;
            }
            if (this.delegateSession == null) {
                this.delegateSession = this.connector.getSession(false, false);
            }
            return this.delegateSession;
        }
        catch (Exception e) {
            throw new MuleException(new Message("jms", 3), (Throwable)e);
        }
    }

    public UMOConnector getConnector() {
        return this.connector;
    }

    protected void doDispose() {
    }

    private class ReplyToListener
    implements MessageListener {
        private Latch latch;
        private javax.jms.Message message;
        private WaitableBoolean released = new WaitableBoolean(false);

        public ReplyToListener(Latch latch) {
            this.latch = latch;
        }

        public javax.jms.Message getMessage() {
            return this.message;
        }

        public void release() {
            this.released.set(true);
        }

        public void onMessage(javax.jms.Message message) {
            this.message = message;
            this.latch.countDown();
            try {
                this.released.whenTrue(null);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

