/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import javax.jms.Message;
import javax.resource.spi.work.Work;
import org.mule.impl.MuleMessage;
import org.mule.providers.jms.SingleJmsMessageReceiver;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;

public class JmsMessageReceiver
extends SingleJmsMessageReceiver {
    public JmsMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
    }

    public void onMessage(Message message) {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Message received of type: " + message.getClass().getName()));
                if (message.getJMSDestination() != null) {
                    this.logger.debug((Object)("Message received on " + message.getJMSDestination() + " (" + message.getJMSDestination().getClass().getName() + ")"));
                } else {
                    this.logger.debug((Object)"Message received on unknown destination");
                }
                this.logger.debug((Object)("Message CorrelationId is: " + message.getJMSCorrelationID()));
                this.logger.debug((Object)("Jms Message Id is: " + message.getJMSMessageID()));
            }
            if (message.getJMSRedelivered()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Message with correlationId: " + message.getJMSCorrelationID() + " has redelivered flag set, handing off to Exception Handler"));
                }
                this.redeliveryHandler.handleRedelivery(message);
            }
            this.getWorkManager().scheduleWork((Work)new Worker(message));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private class Worker
    implements Work {
        private Message message;

        public Worker(Message message) {
            this.message = message;
        }

        public void run() {
            try {
                UMOMessageAdapter adapter = JmsMessageReceiver.this.connector.getMessageAdapter(this.message);
                JmsMessageReceiver.this.routeMessage((UMOMessage)new MuleMessage((Object)adapter));
            }
            catch (Exception e) {
                JmsMessageReceiver.this.getConnector().handleException(e);
            }
        }

        public void release() {
        }
    }
}

