/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.commons.collections.MapUtils;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.ConnectException;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.JmsSupport;
import org.mule.providers.jms.RedeliveryHandler;
import org.mule.providers.jms.filters.JmsSelectorFilter;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.LifecycleException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;

public class SingleJmsMessageReceiver
extends AbstractMessageReceiver
implements MessageListener {
    protected JmsConnector connector;
    protected RedeliveryHandler redeliveryHandler;
    protected MessageConsumer consumer;
    protected Session session;
    protected boolean startOnConnect = false;

    public SingleJmsMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
        this.connector = (JmsConnector)connector;
        try {
            this.redeliveryHandler = this.connector.createRedeliveryHandler();
            this.redeliveryHandler.setConnector(this.connector);
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Object)this);
        }
    }

    public void doConnect() throws Exception {
        this.createConsumer();
        if (this.startOnConnect) {
            this.doStart();
        }
    }

    public void doDisconnect() throws Exception {
        this.closeConsumer();
    }

    public void onMessage(Message message) {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Message received it is of type: " + message.getClass().getName()));
                if (message.getJMSDestination() != null) {
                    this.logger.debug((Object)("Message received on " + message.getJMSDestination() + " (" + message.getJMSDestination().getClass().getName() + ")"));
                } else {
                    this.logger.debug((Object)"Message received on unknown destination");
                }
                this.logger.debug((Object)("Message CorrelationId is: " + message.getJMSCorrelationID()));
                this.logger.debug((Object)("Jms Message Id is: " + message.getJMSMessageID()));
            }
            if (message.getJMSRedelivered()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Message with correlationId: " + message.getJMSCorrelationID() + " is redelivered. handing off to Exception Handler"));
                }
                this.redeliveryHandler.handleRedelivery(message);
            }
            UMOMessageAdapter adapter = this.connector.getMessageAdapter(message);
            this.routeMessage((UMOMessage)new MuleMessage((Object)adapter));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void doStart() throws UMOException {
        try {
            if (this.consumer == null) {
                this.startOnConnect = true;
            } else {
                this.startOnConnect = false;
                this.consumer.setMessageListener((MessageListener)this);
            }
        }
        catch (JMSException e) {
            throw new LifecycleException((Throwable)e, (Object)this);
        }
    }

    public void doStop() throws UMOException {
        try {
            if (this.consumer != null) {
                this.consumer.setMessageListener(null);
            }
        }
        catch (JMSException e) {
            throw new LifecycleException((Throwable)e, (Object)this);
        }
    }

    protected void closeConsumer() {
        this.connector.closeQuietly(this.consumer);
        this.consumer = null;
        this.connector.closeQuietly(this.session);
        this.session = null;
    }

    protected void createConsumer() throws Exception {
        try {
            String durableName;
            String resourceInfo;
            boolean topic;
            JmsSupport jmsSupport = this.connector.getJmsSupport();
            if (this.session == null) {
                this.session = this.connector.getSession((UMOImmutableEndpoint)this.endpoint);
            }
            boolean bl = topic = (resourceInfo = this.endpoint.getEndpointURI().getResourceInfo()) != null && "topic".equalsIgnoreCase(resourceInfo);
            if (!topic) {
                topic = MapUtils.getBooleanValue((Map)this.endpoint.getProperties(), (Object)"topic", (boolean)false);
            }
            Destination dest = jmsSupport.createDestination(this.session, this.endpoint.getEndpointURI().getAddress(), topic);
            String selector = null;
            if (this.endpoint.getFilter() != null && this.endpoint.getFilter() instanceof JmsSelectorFilter) {
                selector = ((JmsSelectorFilter)this.endpoint.getFilter()).getExpression();
            } else if (this.endpoint.getProperties() != null) {
                selector = (String)this.endpoint.getProperties().get("selector");
            }
            String tempDurable = (String)this.endpoint.getProperties().get("durable");
            boolean durable = this.connector.isDurable();
            if (tempDurable != null) {
                durable = Boolean.valueOf(tempDurable);
            }
            if ((durableName = (String)this.endpoint.getProperties().get("durableName")) == null && durable && dest instanceof Topic) {
                durableName = "mule." + this.connector.getName() + "." + this.endpoint.getEndpointURI().getAddress();
                this.logger.debug((Object)("Jms Connector for this receiver is durable but no durable name has been specified. Defaulting to: " + durableName));
            }
            this.consumer = jmsSupport.createConsumer(this.session, dest, selector, this.connector.isNoLocal(), durableName, topic);
        }
        catch (JMSException e) {
            throw new ConnectException((Throwable)e, (Object)this);
        }
    }
}

