/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms.transformers;

import java.util.Iterator;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.mule.config.i18n.Message;
import org.mule.impl.RequestContext;
import org.mule.impl.internal.notifications.ConnectionNotificationListener;
import org.mule.providers.jms.JmsMessageUtils;
import org.mule.transformers.AbstractTransformer;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOMessage;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.provider.UMOMessageDispatcher;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.compression.CompressionHelper;
import org.mule.util.compression.CompressionStrategy;

public abstract class AbstractJmsTransformer
extends AbstractTransformer
implements ConnectionNotificationListener {
    public static final char REPLACEMENT_CHAR = '_';
    protected boolean requireNewSession = true;
    private Session session = null;

    public Object transform(Object src, Session session) throws TransformerException {
        if (session == null && this.session == null) {
            throw new TransformerException(new Message("jms", 1), (UMOTransformer)this);
        }
        if (session != null) {
            this.session = session;
            this.requireNewSession = false;
        }
        if (src == null) {
            throw new TransformerException(new Message(110, (Object)"null", (Object)"Object"), (UMOTransformer)this);
        }
        Object ret = this.transform(src);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Transformed message from type: " + src.getClass().getName() + " to type: " + ret.getClass().getName()));
        }
        return ret;
    }

    protected javax.jms.Message transformToMessage(Object src) throws TransformerException {
        try {
            if (this.requireNewSession || this.getEndpoint() != null) {
                UMOMessageDispatcher dispatcher = this.getEndpoint().getConnector().getDispatcher(this.getEndpoint());
                this.session = (Session)dispatcher.getDelegateSession();
                this.requireNewSession = this.session == null;
            }
            javax.jms.Message msg = null;
            if (src instanceof javax.jms.Message) {
                msg = (javax.jms.Message)src;
                msg.clearProperties();
            } else {
                msg = JmsMessageUtils.getMessageForObject(src, this.session);
            }
            UMOEventContext ctx = RequestContext.getEventContext();
            if (ctx == null) {
                this.logger.warn((Object)"There is no current event context");
                return msg;
            }
            this.setJmsProperties(ctx.getMessage(), msg);
            return msg;
        }
        catch (Exception e) {
            throw new TransformerException((UMOTransformer)this, (Throwable)e);
        }
    }

    protected void setJmsProperties(UMOMessage umoMessage, javax.jms.Message msg) throws JMSException {
        Iterator iterator = umoMessage.getPropertyNames().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            if (key.startsWith("JMS")) continue;
            Object value = umoMessage.getProperty(key);
            if ("MULE_CORRELATION_ID".equals(key)) {
                msg.setJMSCorrelationID(umoMessage.getCorrelationId());
            }
            if ("MULE_REPLYTO".equals(key) && value instanceof Destination) continue;
            try {
                msg.setObjectProperty(AbstractJmsTransformer.encodeHeader(key), value);
            }
            catch (JMSException e) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Unable to set property '" + AbstractJmsTransformer.encodeHeader(key) + "' of type " + value.getClass().getName() + "': " + e.getMessage()));
            }
        }
    }

    public static String encodeHeader(String name) {
        StringBuffer sb = new StringBuffer(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i == 0) {
                if (!Character.isJavaIdentifierStart(c)) {
                    c = '_';
                }
            } else if (!Character.isJavaIdentifierPart(c)) {
                c = '_';
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected Object transformFromMessage(javax.jms.Message source) throws TransformerException {
        Object result = null;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Message type received is: " + source.getClass().getName()));
            }
            if (source instanceof BytesMessage) {
                byte[] bytes = JmsMessageUtils.getBytesFromMessage(source);
                CompressionStrategy strategy = CompressionHelper.getDefaultCompressionStrategy();
                if (strategy.isCompressed(bytes)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"Message received is compressed");
                    }
                    result = strategy.uncompressByteArray(bytes);
                } else {
                    result = JmsMessageUtils.getObjectForMessage(source);
                }
            } else {
                result = JmsMessageUtils.getObjectForMessage(source);
            }
        }
        catch (Exception e) {
            throw new TransformerException((UMOTransformer)this, (Throwable)e);
        }
        return result;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void onNotification(UMOServerNotification notification) {
        if (notification.getAction() == 703) {
            this.session = null;
            this.requireNewSession = true;
        }
    }
}

