/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import java.util.HashMap;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import org.mule.MuleManager;
import org.mule.providers.jms.JmsConnector;
import org.mule.tck.AbstractMuleTestCase;

public class JmsConnectionFactoryTestCase
extends AbstractMuleTestCase {
    public void testProviderPropertiesNotPassed() throws Exception {
        ((MuleManager)MuleManager.getInstance()).initialise();
        JmsConnector connector = new JmsConnector();
        HashMap<String, String> providerProperties = new HashMap<String, String>(1);
        String testProviderProperty = "providerProperty";
        String testValue = "TEST_VALUE";
        providerProperties.put("providerProperty", "TEST_VALUE");
        connector.setJndiProviderProperties(providerProperties);
        TestConnectionFactory cf = new TestConnectionFactory();
        connector.setConnectionFactory((ConnectionFactory)cf);
        connector.initialise();
        JmsConnectionFactoryTestCase.assertEquals((String)"Provider properties should not be passed to the ConnectionFactory.", (String)"NOT_SET", (String)cf.getProviderProperty());
    }

    public void testConnectionFactoryPropertiesPassed() throws Exception {
        ((MuleManager)MuleManager.getInstance()).initialise();
        JmsConnector connector = new JmsConnector();
        HashMap<String, String> connectionFactoryProperties = new HashMap<String, String>(1);
        String testConnectionFactoryProperty = "connectionFactoryProperty";
        String testValue = "TEST_VALUE";
        connectionFactoryProperties.put("connectionFactoryProperty", "TEST_VALUE");
        connector.setConnectionFactoryProperties(connectionFactoryProperties);
        TestConnectionFactory cf = new TestConnectionFactory();
        connector.setConnectionFactory((ConnectionFactory)cf);
        connector.initialise();
        connector.startConnector();
        JmsConnectionFactoryTestCase.assertEquals((String)"ConnectionFactory properties should be passed to the ConnectionFactory.", (String)"TEST_VALUE", (String)cf.getConnectionFactoryProperty());
    }

    public static final class TestConnectionFactory
    implements QueueConnectionFactory {
        private String providerProperty = "NOT_SET";
        private String connectionFactoryProperty = "NOT_SET";

        public Connection createConnection() throws JMSException {
            return null;
        }

        public Connection createConnection(String string, String string1) throws JMSException {
            return null;
        }

        public String getProviderProperty() {
            return this.providerProperty;
        }

        public void setProviderProperty(String providerProperty) {
            throw new IllegalStateException("Should never be called.");
        }

        public String getConnectionFactoryProperty() {
            return this.connectionFactoryProperty;
        }

        public void setConnectionFactoryProperty(String connectionFactoryProperty) {
            this.connectionFactoryProperty = connectionFactoryProperty;
        }

        public QueueConnection createQueueConnection() throws JMSException {
            return null;
        }

        public QueueConnection createQueueConnection(String string, String string1) throws JMSException {
            return null;
        }
    }
}

