/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.Mock;
import java.util.Iterator;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.TextMessage;
import org.apache.commons.collections.IteratorUtils;
import org.mule.providers.jms.JmsConnector;
import org.mule.tck.providers.AbstractConnectorTestCase;
import org.mule.umo.provider.UMOConnector;

public class JmsConnectorTestCase
extends AbstractConnectorTestCase {
    private JmsConnector connector;

    public UMOConnector getConnector() throws Exception {
        if (this.connector == null) {
            this.connector = new JmsConnector();
            this.connector.setName("TestConnector");
            this.connector.setSpecification("1.1");
            Mock connectionFactory = new Mock(ConnectionFactory.class);
            Mock connection = new Mock(Connection.class);
            connectionFactory.expectAndReturn("createConnection", connection.proxy());
            connection.expect("setExceptionListener", (Object)C.isA((Class)ExceptionListener.class));
            connection.expect("close");
            connection.expect("start");
            connection.expect("stop");
            connection.expect("stop");
            connection.expect("setClientID", (Object)"mule.TestConnector");
            this.connector.setConnectionFactory((ConnectionFactory)connectionFactory.proxy());
            this.connector.initialise();
        }
        return this.connector;
    }

    public String getTestEndpointURI() {
        return "jms://test.queue";
    }

    public Object getValidMessage() throws Exception {
        return JmsConnectorTestCase.getMessage();
    }

    public static Object getMessage() throws Exception {
        Mock message = new Mock(TextMessage.class);
        message.expectAndReturn("getText", (Object)"Test JMS Message");
        message.expectAndReturn("getText", (Object)"Test JMS Message");
        message.expectAndReturn("getJMSCorrelationID", null);
        message.expectAndReturn("getJMSMessageID", (Object)"1234567890");
        message.expectAndReturn("getJMSDeliveryMode", (Object)new Integer(1));
        message.expectAndReturn("getJMSDestination", null);
        message.expectAndReturn("getJMSPriority", (Object)new Integer(4));
        message.expectAndReturn("getJMSRedelivered", (Object)Boolean.FALSE);
        message.expectAndReturn("getJMSReplyTo", null);
        message.expectAndReturn("getJMSExpiration", (Object)new Long(0L));
        message.expectAndReturn("getJMSTimestamp", (Object)new Long(0L));
        message.expectAndReturn("getJMSType", null);
        message.expect("toString");
        message.expectAndReturn("getPropertyNames", (Object)IteratorUtils.asEnumeration((Iterator)IteratorUtils.emptyIterator()));
        return message.proxy();
    }
}

