/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import com.mockobjects.constraint.Constraint;
import com.mockobjects.constraint.IsEqual;
import com.mockobjects.dynamic.ConstraintMatcher;
import com.mockobjects.dynamic.FullConstraintMatcher;
import com.mockobjects.dynamic.Mock;
import java.util.Iterator;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.apache.commons.collections.IteratorUtils;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.impl.RequestContext;
import org.mule.providers.jms.JmsMessageAdapter;
import org.mule.providers.jms.transformers.ObjectToJMSMessage;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.MuleTestUtils;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;

public class JmsTransformerTestCase
extends AbstractMuleTestCase {
    public void testCustomJMSProperty() throws Exception {
        Mock mockMessage = new Mock(TextMessage.class);
        mockMessage.expectAndReturn("getJMSCorrelationID", null);
        mockMessage.expectAndReturn("getJMSMessageID", (Object)"1234567890");
        mockMessage.expectAndReturn("getJMSDeliveryMode", (Object)new Integer(1));
        mockMessage.expectAndReturn("getJMSDestination", null);
        mockMessage.expectAndReturn("getJMSPriority", (Object)new Integer(4));
        mockMessage.expectAndReturn("getJMSRedelivered", (Object)Boolean.FALSE);
        mockMessage.expectAndReturn("getJMSReplyTo", null);
        mockMessage.expectAndReturn("getJMSExpiration", (Object)new Long(0L));
        mockMessage.expectAndReturn("getJMSTimestamp", (Object)new Long(0L));
        mockMessage.expectAndReturn("getJMSType", null);
        mockMessage.expect("toString");
        mockMessage.expect("toString");
        mockMessage.expect("clearProperties");
        mockMessage.expectAndReturn("getPropertyNames", (Object)IteratorUtils.asEnumeration((Iterator)IteratorUtils.emptyIterator()));
        mockMessage.expectAndReturn("getObjectProperty", (Object)"JMS_CUSTOM_PROPERTY", (Object)"customValue");
        FullConstraintMatcher setPropertyMatcher = new FullConstraintMatcher(new Constraint[]{new IsEqual((Object)"JMS_CUSTOM_PROPERTY"), new IsEqual((Object)"customValue")});
        mockMessage.expect("setObjectProperty", (ConstraintMatcher)setPropertyMatcher);
        Message mockTextMessage = (Message)mockMessage.proxy();
        MuleMessage msg = new MuleMessage((Object)new JmsMessageAdapter((Object)mockTextMessage));
        msg.setProperty("JMS_CUSTOM_PROPERTY", (Object)"customValue");
        RequestContext.setEvent((UMOEvent)new MuleEvent((UMOMessage)msg, MuleTestUtils.getTestEvent((Object)"previous")));
        ObjectToJMSMessage transformer = new ObjectToJMSMessage();
        Message transformed = (Message)transformer.transform(msg.getPayload());
        JmsTransformerTestCase.assertEquals((Object)"customValue", (Object)transformed.getObjectProperty("JMS_CUSTOM_PROPERTY"));
    }
}

