/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.providers.jms;

import java.util.HashMap;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueConnection;
import javax.jms.TopicConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.builders.QuickConfigurationBuilder;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.impl.model.seda.SedaModel;
import org.mule.providers.jms.JmsConnector;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.test.integration.providers.jms.tools.JmsTestUtils;
import org.mule.umo.endpoint.MalformedEndpointException;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOConnector;

public abstract class AbstractJmsFunctionalTestCase
extends AbstractMuleTestCase {
    public static final String DEFAULT_IN_QUEUE = "jms://in.q";
    public static final String DEFAULT_OUT_QUEUE = "jms://out.q";
    public static final String DEFAULT_DL_QUEUE = "jms://dlq";
    public static final String DEFAULT_IN_TOPIC = "jms://topic:in.t";
    public static final String DEFAULT_OUT_TOPIC = "jms://topic:out.t";
    public static final String DEFAULT_DL_TOPIC = "jms://topic:dlt";
    public static final String DEFAULT_MESSAGE = "Test Message";
    public static final String CONNECTOR_NAME = "testConnector";
    public static final long LOCK_WAIT = 20000L;
    protected JmsConnector connector;
    protected volatile boolean callbackCalled = false;
    protected Connection cnn;
    protected volatile Message currentMsg;
    protected volatile int eventCount = 0;
    protected UMOModel model;
    protected final transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    protected void doSetUp() throws Exception {
        MuleManager.getConfiguration().setSynchronous(true);
        MuleManager.getConfiguration().getPoolingProfile().setInitialisationPolicy(1);
        this.model = new SedaModel();
        this.model.setName("main");
        MuleManager.getInstance().registerModel(this.model);
        this.callbackCalled = false;
        ConnectionFactory cf = this.getConnectionFactory();
        this.cnn = this.getSenderConnection();
        this.cnn.start();
        this.connector = this.createConnector();
        this.connector.setConnectionFactory(cf);
        MuleManager.getInstance().registerConnector((UMOConnector)this.connector);
        this.currentMsg = null;
        this.eventCount = 0;
    }

    protected Connection getSenderConnection() throws Exception {
        return this.getConnectionFactory().createConnection();
    }

    protected void doTearDown() throws Exception {
        try {
            if (this.cnn != null) {
                this.cnn.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public abstract ConnectionFactory getConnectionFactory() throws Exception;

    public void initialiseComponent(EventCallback callback) throws Exception {
        QuickConfigurationBuilder builder = new QuickConfigurationBuilder();
        HashMap<String, EventCallback> props = new HashMap<String, EventCallback>();
        props.put("eventCallback", callback);
        builder.registerComponent(FunctionalTestComponent.class.getName(), "testComponent", this.getInDest(), this.getOutDest(), props);
    }

    public void afterInitialise() throws Exception {
    }

    protected UMOEndpointURI getInDest() {
        try {
            if (!this.useTopics()) {
                return new MuleEndpointURI(DEFAULT_IN_QUEUE);
            }
            return new MuleEndpointURI(DEFAULT_IN_TOPIC);
        }
        catch (MalformedEndpointException e) {
            AbstractJmsFunctionalTestCase.fail((String)e.getMessage());
            return null;
        }
    }

    protected UMOEndpointURI getOutDest() {
        try {
            if (!this.useTopics()) {
                return new MuleEndpointURI(DEFAULT_OUT_QUEUE);
            }
            return new MuleEndpointURI(DEFAULT_OUT_TOPIC);
        }
        catch (Exception e) {
            AbstractJmsFunctionalTestCase.fail((String)e.getMessage());
            return null;
        }
    }

    protected void send(String payload, boolean transacted, int ack, String replyTo) throws JMSException {
        if (!this.useTopics()) {
            JmsTestUtils.queueSend((QueueConnection)this.cnn, this.getInDest().getAddress(), payload, transacted, ack, replyTo);
        } else {
            JmsTestUtils.topicPublish((TopicConnection)this.cnn, this.getInDest().getAddress(), payload, transacted, ack, replyTo);
        }
    }

    protected Message receive(String dest, long timeout) throws JMSException {
        Message msg = null;
        msg = !this.useTopics() ? JmsTestUtils.queueReceiver((QueueConnection)this.cnn, dest, timeout) : JmsTestUtils.topicSubscribe((TopicConnection)this.cnn, dest, timeout);
        return msg;
    }

    public boolean useTopics() {
        return false;
    }

    public abstract JmsConnector createConnector() throws Exception;
}

