/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.providers.jms;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.QueueConnection;
import javax.jms.TextMessage;
import javax.jms.TopicConnection;
import junit.framework.Assert;
import org.mule.MuleManager;
import org.mule.providers.jms.JmsMessageReceiver;
import org.mule.tck.functional.EventCallback;
import org.mule.test.integration.providers.jms.AbstractJmsFunctionalTestCase;
import org.mule.test.integration.providers.jms.tools.JmsTestUtils;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEventContext;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;

public abstract class AbstractJmsQueueFunctionalTestCase
extends AbstractJmsFunctionalTestCase {
    protected static CountDownLatch receiverIsUp;

    public void testSend() throws Exception {
        final CountDownLatch countDown = new CountDownLatch(2);
        receiverIsUp = new CountDownLatch(1);
        EventCallback callback = new EventCallback(){

            public synchronized void eventReceived(UMOEventContext context, Object Component) {
                AbstractJmsQueueFunctionalTestCase.this.callbackCalled = true;
                Assert.assertNull((Object)context.getCurrentTransaction());
                countDown.countDown();
            }
        };
        this.initialiseComponent(callback);
        MuleManager.getInstance().start();
        Object mc = this.useTopics() ? JmsTestUtils.getTopicSubscriber((TopicConnection)this.cnn, this.getOutDest().getAddress()) : JmsTestUtils.getQueueReceiver((QueueConnection)this.cnn, this.getOutDest().getAddress());
        mc.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                AbstractJmsQueueFunctionalTestCase.this.currentMsg = message;
                countDown.countDown();
            }
        });
        this.logger.debug((Object)"Waiting for coutdown isReceiverUp");
        AbstractJmsQueueFunctionalTestCase.assertTrue((boolean)receiverIsUp.await(20000L, TimeUnit.MILLISECONDS));
        receiverIsUp = null;
        this.send("Test Message", false, 1, null);
        AbstractJmsQueueFunctionalTestCase.assertTrue((boolean)countDown.await(20000L, TimeUnit.MILLISECONDS));
        AbstractJmsQueueFunctionalTestCase.assertNotNull((Object)this.currentMsg);
        AbstractJmsQueueFunctionalTestCase.assertTrue((boolean)(this.currentMsg instanceof TextMessage));
        AbstractJmsQueueFunctionalTestCase.assertEquals((String)"Test Message Received", (String)((TextMessage)this.currentMsg).getText());
        AbstractJmsQueueFunctionalTestCase.assertTrue((boolean)this.callbackCalled);
    }

    public void testSendWithReplyTo() throws Exception {
        final CountDownLatch countDown = new CountDownLatch(2);
        receiverIsUp = new CountDownLatch(1);
        EventCallback callback = new EventCallback(){

            public synchronized void eventReceived(UMOEventContext context, Object Component) {
                AbstractJmsQueueFunctionalTestCase.this.callbackCalled = true;
                Assert.assertNull((Object)context.getCurrentTransaction());
                countDown.countDown();
            }
        };
        this.initialiseComponent(callback);
        MuleManager.getInstance().start();
        Object mc = this.useTopics() ? JmsTestUtils.getTopicSubscriber((TopicConnection)this.cnn, "replyto") : JmsTestUtils.getQueueReceiver((QueueConnection)this.cnn, "replyto");
        mc.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                AbstractJmsQueueFunctionalTestCase.this.currentMsg = message;
                countDown.countDown();
            }
        });
        this.logger.debug((Object)"Waiting for coutdown isReceiverUp");
        AbstractJmsQueueFunctionalTestCase.assertTrue((boolean)receiverIsUp.await(20000L, TimeUnit.MILLISECONDS));
        receiverIsUp = null;
        this.send("Test Message", false, 1, "replyto");
        AbstractJmsQueueFunctionalTestCase.assertTrue((boolean)countDown.await(20000L, TimeUnit.MILLISECONDS));
        AbstractJmsQueueFunctionalTestCase.assertNotNull((Object)this.currentMsg);
        AbstractJmsQueueFunctionalTestCase.assertTrue((boolean)(this.currentMsg instanceof TextMessage));
        AbstractJmsQueueFunctionalTestCase.assertEquals((String)"Test Message Received", (String)((TextMessage)this.currentMsg).getText());
        AbstractJmsQueueFunctionalTestCase.assertTrue((boolean)this.callbackCalled);
    }

    public boolean useTopics() {
        return false;
    }

    protected static class JmsMessageReceiverSynchronous
    extends JmsMessageReceiver {
        public JmsMessageReceiverSynchronous(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
            super(connector, component, endpoint);
        }

        protected void doConnect() throws Exception {
            super.doConnect();
            if (receiverIsUp != null) {
                this.logger.debug((Object)"Releasing coutdown isReceiverUp");
                receiverIsUp.countDown();
            }
        }
    }
}

