/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.providers.jms;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.beans.ExceptionListener;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.QueueConnection;
import javax.jms.TextMessage;
import javax.jms.TopicConnection;
import junit.framework.Assert;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.mule.MuleManager;
import org.mule.impl.DefaultExceptionStrategy;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.MuleTransactionConfig;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.MessageRedeliveredException;
import org.mule.providers.jms.transformers.JMSMessageToObject;
import org.mule.providers.jms.transformers.ObjectToJMSMessage;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.test.integration.providers.jms.AbstractJmsFunctionalTestCase;
import org.mule.test.integration.providers.jms.tools.JmsTestUtils;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOTransaction;
import org.mule.umo.UMOTransactionConfig;
import org.mule.umo.UMOTransactionFactory;
import org.mule.umo.endpoint.MalformedEndpointException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.manager.UMOManager;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.transformer.UMOTransformer;

public abstract class AbstractJmsTransactionFunctionalTest
extends AbstractJmsFunctionalTestCase {
    protected volatile UMOTransaction currentTx;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.currentTx = null;
    }

    protected void doTearDown() throws Exception {
        TransactionCoordination.getInstance().unbindTransaction(TransactionCoordination.getInstance().getTransaction());
        super.doTearDown();
    }

    public void testSendNotTransacted() throws Exception {
        UMODescriptor descriptor = AbstractJmsTransactionFunctionalTest.getDescriptor("testComponent", FunctionalTestComponent.class.getName());
        int countDownInitialCount = 2;
        final CountDownLatch countDown = new CountDownLatch(2);
        EventCallback callback = new EventCallback(){

            public synchronized void eventReceived(UMOEventContext context, Object Component) {
                AbstractJmsTransactionFunctionalTest.this.callbackCalled = true;
                Assert.assertNull((Object)context.getCurrentTransaction());
                countDown.countDown();
            }
        };
        this.initialiseComponent(descriptor, (byte)0, callback);
        this.addResultListener(this.getOutDest().getAddress(), countDown);
        MuleManager.getInstance().start();
        this.afterInitialise();
        this.send("Test Message", false, 1);
        countDown.await(20000L, TimeUnit.MILLISECONDS);
        AbstractJmsTransactionFunctionalTest.assertTrue((String)("Only " + (2L - countDown.getCount()) + " of " + 2 + " checkpoints hit"), (countDown.getCount() == 0L ? 1 : 0) != 0);
        AbstractJmsTransactionFunctionalTest.assertNotNull((Object)this.currentMsg);
        AbstractJmsTransactionFunctionalTest.assertTrue((boolean)(this.currentMsg instanceof TextMessage));
        AbstractJmsTransactionFunctionalTest.assertEquals((String)"Test Message Received", (String)((TextMessage)this.currentMsg).getText());
        AbstractJmsTransactionFunctionalTest.assertTrue((boolean)this.callbackCalled);
        AbstractJmsTransactionFunctionalTest.assertNull((Object)this.currentTx);
    }

    public void testSendTransactedAlways() throws Exception {
        int countDownInitialCount = 2;
        final CountDownLatch countDown = new CountDownLatch(2);
        UMODescriptor descriptor = AbstractJmsTransactionFunctionalTest.getDescriptor("testComponent", FunctionalTestComponent.class.getName());
        EventCallback callback = new EventCallback(){

            public synchronized void eventReceived(UMOEventContext context, Object Component) throws Exception {
                AbstractJmsTransactionFunctionalTest.this.callbackCalled = true;
                AbstractJmsTransactionFunctionalTest.this.currentTx = context.getCurrentTransaction();
                Assert.assertNotNull((Object)AbstractJmsTransactionFunctionalTest.this.currentTx);
                Assert.assertTrue((boolean)AbstractJmsTransactionFunctionalTest.this.currentTx.isBegun());
                countDown.countDown();
            }
        };
        this.initialiseComponent(descriptor, (byte)1, callback);
        MuleManager.getInstance().start();
        this.addResultListener(this.getOutDest().getAddress(), countDown);
        this.send("Test Message", false, this.getAcknowledgementMode());
        countDown.await(20000L, TimeUnit.MILLISECONDS);
        AbstractJmsTransactionFunctionalTest.assertTrue((String)("Only " + (2L - countDown.getCount()) + " of " + 2 + " checkpoints hit"), (countDown.getCount() == 0L ? 1 : 0) != 0);
        AbstractJmsTransactionFunctionalTest.assertNotNull((Object)this.currentMsg);
        AbstractJmsTransactionFunctionalTest.assertTrue((boolean)(this.currentMsg instanceof TextMessage));
        AbstractJmsTransactionFunctionalTest.assertEquals((String)"Test Message Received", (String)((TextMessage)this.currentMsg).getText());
        AbstractJmsTransactionFunctionalTest.assertTrue((boolean)this.callbackCalled);
        AbstractJmsTransactionFunctionalTest.assertTrue((boolean)this.currentTx.isBegun());
        Thread.sleep(1000L);
        AbstractJmsTransactionFunctionalTest.assertTrue((boolean)this.currentTx.isCommitted());
    }

    public void testSendTransactedIfPossibleWithTransaction() throws Exception {
        this.doSendTransactedIfPossible(true);
    }

    public void testSendTransactedIfPossibleWithoutTransaction() throws Exception {
        this.doSendTransactedIfPossible(false);
    }

    private void doSendTransactedIfPossible(final boolean transactionAvailable) throws Exception {
        int countDownInitialCount = 2;
        final CountDownLatch countDown = new CountDownLatch(2);
        UMODescriptor descriptor = AbstractJmsTransactionFunctionalTest.getDescriptor("testComponent", FunctionalTestComponent.class.getName());
        EventCallback callback = new EventCallback(){

            public synchronized void eventReceived(UMOEventContext context, Object Component) throws Exception {
                AbstractJmsTransactionFunctionalTest.this.callbackCalled = true;
                AbstractJmsTransactionFunctionalTest.this.currentTx = context.getCurrentTransaction();
                if (transactionAvailable) {
                    Assert.assertNotNull((Object)AbstractJmsTransactionFunctionalTest.this.currentTx);
                    Assert.assertTrue((boolean)AbstractJmsTransactionFunctionalTest.this.currentTx.isBegun());
                } else {
                    Assert.assertNull((Object)AbstractJmsTransactionFunctionalTest.this.currentTx);
                }
                countDown.countDown();
            }
        };
        this.initialiseComponent(descriptor, transactionAvailable ? (byte)1 : 0, callback);
        MuleManager.getInstance().start();
        this.addResultListener(this.getOutDest().getAddress(), countDown);
        this.send("Test Message", false, 1);
        countDown.await(20000L, TimeUnit.MILLISECONDS);
        AbstractJmsTransactionFunctionalTest.assertTrue((String)("Only " + (2L - countDown.getCount()) + " of " + 2 + " checkpoints hit"), (boolean)countDown.await(20000L, TimeUnit.MILLISECONDS));
        AbstractJmsTransactionFunctionalTest.assertNotNull((Object)this.currentMsg);
        AbstractJmsTransactionFunctionalTest.assertTrue((boolean)(this.currentMsg instanceof TextMessage));
        AbstractJmsTransactionFunctionalTest.assertEquals((String)"Test Message Received", (String)((TextMessage)this.currentMsg).getText());
        AbstractJmsTransactionFunctionalTest.assertTrue((boolean)this.callbackCalled);
        if (transactionAvailable) {
            AbstractJmsTransactionFunctionalTest.assertNotNull((Object)this.currentTx);
            AbstractJmsTransactionFunctionalTest.assertTrue((boolean)this.currentTx.isBegun());
            Thread.sleep(300L);
            AbstractJmsTransactionFunctionalTest.assertTrue((boolean)this.currentTx.isCommitted());
        } else {
            AbstractJmsTransactionFunctionalTest.assertNull((Object)this.currentTx);
        }
    }

    public void testSendTransactedRollback() throws Exception {
        int countDownInitialCount = 2;
        final CountDownLatch countDown = new CountDownLatch(2);
        UMODescriptor descriptor = AbstractJmsTransactionFunctionalTest.getDescriptor("testComponent", FunctionalTestComponent.class.getName());
        EventCallback callback = new EventCallback(){

            public synchronized void eventReceived(UMOEventContext context, Object Component) throws Exception {
                AbstractJmsTransactionFunctionalTest.this.callbackCalled = true;
                AbstractJmsTransactionFunctionalTest.this.currentTx = context.getCurrentTransaction();
                Assert.assertNotNull((Object)AbstractJmsTransactionFunctionalTest.this.currentTx);
                Assert.assertTrue((boolean)AbstractJmsTransactionFunctionalTest.this.currentTx.isBegun());
                AbstractJmsTransactionFunctionalTest.this.logger.debug((Object)"@@@@ Rolling back transaction @@@@");
                AbstractJmsTransactionFunctionalTest.this.currentTx.setRollbackOnly();
                countDown.countDown();
            }
        };
        this.initialiseComponent(descriptor, (byte)1, callback);
        UMOManager manager = MuleManager.getInstance();
        this.addResultListener(this.getOutDest().getAddress(), countDown);
        UMOConnector umoCnn = manager.lookupConnector("testConnector");
        umoCnn.setExceptionListener((ExceptionListener)((Object)new RollbackExceptionListener(countDown)));
        manager.start();
        this.send("Test Message", false, 1);
        this.afterInitialise();
        countDown.await(20000L, TimeUnit.MILLISECONDS);
        AbstractJmsTransactionFunctionalTest.assertTrue((String)("Only " + (2L - countDown.getCount()) + " of " + 2 + " checkpoints hit"), (countDown.getCount() == 0L ? 1 : 0) != 0);
        this.afterInitialise();
        AbstractJmsTransactionFunctionalTest.assertNull((Object)this.currentMsg);
        AbstractJmsTransactionFunctionalTest.assertTrue((boolean)this.callbackCalled);
        AbstractJmsTransactionFunctionalTest.assertTrue((boolean)this.currentTx.isRolledBack());
        AbstractJmsTransactionFunctionalTest.assertNull((Object)this.receive(this.getInDest().getAddress(), 2000L));
    }

    public void testCleanup() throws Exception {
        AbstractJmsTransactionFunctionalTest.assertNull((String)"There should be no transaction associated with this thread", (Object)TransactionCoordination.getInstance().getTransaction());
    }

    public UMOComponent initialiseComponent(UMODescriptor descriptor, byte txBeginAction, EventCallback callback) throws Exception {
        JMSMessageToObject inTrans = new JMSMessageToObject();
        ObjectToJMSMessage outTrans = new ObjectToJMSMessage();
        MuleEndpoint endpoint = new MuleEndpoint("testIn", this.getInDest(), (UMOConnector)this.connector, (UMOTransformer)inTrans, "receiver", 0, null, null);
        MuleTransactionConfig txConfig = new MuleTransactionConfig();
        txConfig.setFactory(this.getTransactionFactory());
        txConfig.setAction(txBeginAction);
        MuleEndpoint outProvider = new MuleEndpoint("testOut", this.getOutDest(), (UMOConnector)this.connector, (UMOTransformer)outTrans, "sender", 0, null, null);
        endpoint.setTransactionConfig((UMOTransactionConfig)txConfig);
        descriptor.setOutboundEndpoint((UMOEndpoint)outProvider);
        descriptor.setInboundEndpoint((UMOEndpoint)endpoint);
        HashMap<String, EventCallback> props = new HashMap<String, EventCallback>();
        props.put("eventCallback", callback);
        descriptor.setProperties(props);
        UMOComponent component = this.model.registerComponent(descriptor);
        return component;
    }

    public static UMODescriptor getDescriptor(String name, String implementation) {
        MuleDescriptor descriptor = new MuleDescriptor();
        descriptor.setExceptionListener((ExceptionListener)new DefaultExceptionStrategy());
        descriptor.setName(name);
        descriptor.setImplementation((Object)implementation);
        return descriptor;
    }

    public void afterInitialise() throws Exception {
        Thread.sleep(1000L);
    }

    protected UMOEndpointURI getInDest() {
        try {
            if (this.cnn instanceof QueueConnection) {
                return new MuleEndpointURI("jms://in.q");
            }
            return new MuleEndpointURI("jms://topic:in.t");
        }
        catch (MalformedEndpointException e) {
            AbstractJmsTransactionFunctionalTest.fail((String)e.getMessage());
            return null;
        }
    }

    protected UMOEndpointURI getOutDest() {
        try {
            if (this.cnn instanceof QueueConnection) {
                return new MuleEndpointURI("jms://out.q");
            }
            return new MuleEndpointURI("jms://topic:out.t");
        }
        catch (MalformedEndpointException e) {
            AbstractJmsTransactionFunctionalTest.fail((String)e.getMessage());
            return null;
        }
    }

    protected UMOEndpointURI getDLDest() {
        try {
            if (this.cnn instanceof QueueConnection) {
                return new MuleEndpointURI("jms://dlq");
            }
            return new MuleEndpointURI("jms://topic:dlt");
        }
        catch (MalformedEndpointException e) {
            AbstractJmsTransactionFunctionalTest.fail((String)e.getMessage());
            return null;
        }
    }

    protected void send(String payload, boolean transacted, int ack) throws JMSException {
        if (this.cnn instanceof QueueConnection) {
            JmsTestUtils.queueSend((QueueConnection)this.cnn, this.getInDest().getAddress(), payload, transacted, ack, null);
        } else {
            JmsTestUtils.topicPublish((TopicConnection)this.cnn, this.getInDest().getAddress(), payload, transacted, ack);
        }
    }

    protected int getAcknowledgementMode() {
        return 1;
    }

    protected void addResultListener(String dest, final CountDownLatch countDown) throws JMSException {
        Object mc = this.useTopics() ? JmsTestUtils.getTopicSubscriber((TopicConnection)this.cnn, dest) : JmsTestUtils.getQueueReceiver((QueueConnection)this.cnn, dest);
        mc.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                AbstractJmsTransactionFunctionalTest.this.currentMsg = message;
                if (countDown != null) {
                    countDown.countDown();
                }
            }
        });
    }

    public abstract UMOTransactionFactory getTransactionFactory();

    public void testTransactedRedeliveryToDLDestination() throws Exception {
        int countDownInitialCount = 4;
        final CountDownLatch countDown = new CountDownLatch(4);
        UMODescriptor descriptor = AbstractJmsTransactionFunctionalTest.getDescriptor("testComponent", FunctionalTestComponent.class.getName());
        EventCallback callback = new EventCallback(){

            public synchronized void eventReceived(UMOEventContext context, Object Component) throws Exception {
                AbstractJmsTransactionFunctionalTest.this.callbackCalled = true;
                AbstractJmsTransactionFunctionalTest.this.currentTx = context.getCurrentTransaction();
                Assert.assertNotNull((Object)AbstractJmsTransactionFunctionalTest.this.currentTx);
                Assert.assertTrue((boolean)AbstractJmsTransactionFunctionalTest.this.currentTx.isBegun());
                AbstractJmsTransactionFunctionalTest.this.logger.debug((Object)"@@@@ Rolling back transaction @@@@");
                AbstractJmsTransactionFunctionalTest.this.currentTx.setRollbackOnly();
                countDown.countDown();
            }
        };
        this.initialiseComponent(descriptor, (byte)1, callback);
        UMOManager manager = MuleManager.getInstance();
        this.addResultListener(this.getDLDest().getAddress(), countDown);
        JmsConnector umoCnn = (JmsConnector)manager.lookupConnector("testConnector");
        umoCnn.setMaxRedelivery(1);
        umoCnn.setExceptionListener((ExceptionListener)((Object)new RollbackExceptionListener(countDown, this.getDLDest())));
        manager.start();
        this.send("Test Message", false, 1);
        this.afterInitialise();
        countDown.await(20000L, TimeUnit.MILLISECONDS);
        AbstractJmsTransactionFunctionalTest.assertTrue((String)("Only " + (4L - countDown.getCount()) + " of " + 4 + " checkpoints hit"), (countDown.getCount() == 0L ? 1 : 0) != 0);
        AbstractJmsTransactionFunctionalTest.assertNotNull((Object)this.currentMsg);
        this.logger.debug((Object)this.currentMsg);
        String dest = this.currentMsg.getStringProperty("MULE_ENDPOINT");
        AbstractJmsTransactionFunctionalTest.assertNotNull((Object)dest);
        AbstractJmsTransactionFunctionalTest.assertEquals((String)this.getDLDest().getUri().toString(), (String)dest);
        AbstractJmsTransactionFunctionalTest.assertTrue((boolean)this.callbackCalled);
        AbstractJmsTransactionFunctionalTest.assertNull((Object)this.receive(this.getInDest().getAddress(), 2000L));
    }

    public class RollbackExceptionListener
    extends DefaultExceptionStrategy {
        private CountDownLatch countDown;

        public RollbackExceptionListener(CountDownLatch countDown) {
            this.countDown = countDown;
        }

        public RollbackExceptionListener(CountDownLatch countDown, UMOEndpointURI deadLetter) throws UMOException {
            this.countDown = countDown;
            UMOEndpoint ep = MuleEndpoint.createEndpointFromUri((UMOEndpointURI)deadLetter, (String)"sender");
            ep.setTransactionConfig((UMOTransactionConfig)new MuleTransactionConfig());
            ep.getTransactionConfig().setAction((byte)4);
            super.addEndpoint(ep);
        }

        public void handleMessagingException(UMOMessage message, Throwable t) {
            this.logger.debug((Object)"@@@@ ExceptionHandler Called @@@@");
            if (t instanceof MessageRedeliveredException) {
                this.countDown.countDown();
                try {
                    Message msg = (Message)message.getPayload();
                    Assert.assertNotNull((Object)msg);
                    Assert.assertTrue((boolean)msg.getJMSRedelivered());
                    Assert.assertTrue((boolean)(msg instanceof TextMessage));
                    super.handleMessagingException(message, t);
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
            } else {
                this.logger.error((Object)ExceptionUtils.getFullStackTrace((Throwable)t));
                Assert.fail((String)t.getMessage());
            }
            super.handleMessagingException(message, t);
        }

        public void handleException(Throwable t) {
        }
    }
}

