/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.providers.jms.activemq;

import java.util.HashMap;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.transaction.TransactionManager;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.mule.MuleManager;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.TransactedJmsMessageReceiver;
import org.mule.providers.jms.activemq.ActiveMqJmsConnector;
import org.mule.test.integration.providers.jms.activemq.ActiveMQJmsTransactionFunctionalTestCase;
import org.mule.transaction.XaTransactionFactory;
import org.mule.umo.UMOTransactionFactory;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.Jotm;

public class ActiveMQJmsXaTransactionFunctionalTestCase
extends ActiveMQJmsTransactionFunctionalTestCase {
    private TransactionManager txManager;

    public ConnectionFactory getConnectionFactory() throws Exception {
        if (this.factory == null) {
            this.factory = new ActiveMQXAConnectionFactory("vm://localhost?broker.persistent=false&broker.useJmx=false");
        }
        return this.factory;
    }

    public Connection getSenderConnection() throws Exception {
        this.factory = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false&broker.useJmx=false");
        return this.factory.createConnection();
    }

    protected void doSetUp() throws Exception {
        this.txManager = Current.getCurrent();
        if (this.txManager == null) {
            new Jotm(true, false);
            this.txManager = Current.getCurrent();
        }
        this.txManager.setTransactionTimeout(15000);
        super.doSetUp();
        MuleManager.getInstance().setTransactionManager(this.txManager);
    }

    public JmsConnector createConnector() throws Exception {
        ActiveMqJmsConnector connector = new ActiveMqJmsConnector();
        connector.setName("testConnector");
        HashMap<String, String> overrides = new HashMap<String, String>();
        overrides.put("transacted.message.receiver", TransactedJmsMessageReceiver.class.getName());
        connector.setServiceOverrides(overrides);
        connector.setSpecification("1.1");
        connector.setConnectionFactoryJndiName("XAJmsQueueConnectionFactory");
        return connector;
    }

    public UMOTransactionFactory getTransactionFactory() {
        return new XaTransactionFactory();
    }

    public void afterInitialise() throws Exception {
        Thread.sleep(5000L);
    }

    public void testSendNotTransacted() throws Exception {
    }

    public void testSendTransactedIfPossibleWithoutTransaction() throws Exception {
    }
}

