/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import com.mockobjects.dynamic.Mock;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Topic;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.providers.jms.DefaultJmsTopicResolver;
import org.mule.providers.jms.JmsConnector;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.umo.endpoint.UMOImmutableEndpoint;

public class DefaultJmsTopicResolverTestCase
extends AbstractMuleTestCase {
    private JmsConnector connector;
    private DefaultJmsTopicResolver resolver;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.connector = new JmsConnector();
        this.resolver = new DefaultJmsTopicResolver(this.connector);
    }

    public void testSameConnector() {
        DefaultJmsTopicResolverTestCase.assertSame((Object)this.connector, (Object)this.resolver.getConnector());
    }

    public void testEndpointNotTopicNoFallback() throws Exception {
        MuleEndpoint endpoint = new MuleEndpoint("jms://queue.NotATopic", true);
        DefaultJmsTopicResolverTestCase.assertFalse((boolean)this.resolver.isTopic((UMOImmutableEndpoint)endpoint));
    }

    public void testEndpointTopicNoFallback() throws Exception {
        MuleEndpoint endpoint = new MuleEndpoint("jms://topic:context.ThisIsATopic", true);
        DefaultJmsTopicResolverTestCase.assertTrue((boolean)this.resolver.isTopic((UMOImmutableEndpoint)endpoint));
    }

    public void testEndpointNotTopicWithFallback() throws Exception {
        MuleEndpoint endpoint = new MuleEndpoint("jms://context.aTopic?topic=true", true);
        DefaultJmsTopicResolverTestCase.assertTrue((boolean)this.resolver.isTopic((UMOImmutableEndpoint)endpoint, true));
    }

    public void testEndpointTopicFallbackNotUsed() throws Exception {
        MuleEndpoint endpoint = new MuleEndpoint("jms://topic:context.ThisIsATopic?topic=false", true);
        DefaultJmsTopicResolverTestCase.assertTrue((boolean)this.resolver.isTopic((UMOImmutableEndpoint)endpoint, true));
    }

    public void testDestinationNotTopic() throws Exception {
        Mock mock = new Mock(Queue.class);
        Queue queue = (Queue)mock.proxy();
        DefaultJmsTopicResolverTestCase.assertFalse((boolean)this.resolver.isTopic((Destination)queue));
        mock.verify();
    }

    public void testDestinationTopic() throws Exception {
        Mock mock = new Mock(Topic.class);
        Topic topic = (Topic)mock.proxy();
        DefaultJmsTopicResolverTestCase.assertTrue((boolean)this.resolver.isTopic((Destination)topic));
        mock.verify();
    }
}

