/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import com.mockobjects.constraint.Constraint;
import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.ConstraintMatcher;
import com.mockobjects.dynamic.FullConstraintMatcher;
import com.mockobjects.dynamic.Mock;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import org.mule.providers.jms.Jms11Support;
import org.mule.providers.jms.JmsConnector;
import org.mule.tck.AbstractMuleTestCase;

public class Jms11SupportTestCase
extends AbstractMuleTestCase {
    public void testNoLocalCalledForDurableTopic() throws Exception {
        Jms11Support jmsSupport = new Jms11Support(new JmsConnector(), null, false, false);
        Mock mockTopic = new Mock(Topic.class);
        Topic topic = (Topic)mockTopic.proxy();
        String durableName = "durableName";
        boolean noLocal = true;
        FullConstraintMatcher matcher = new FullConstraintMatcher(new Constraint[]{C.eq((Object)topic), C.eq((Object)durableName), C.IS_NULL, C.IS_TRUE});
        Mock mockSession = new Mock(Session.class);
        mockSession.expect("createDurableSubscriber", (ConstraintMatcher)matcher);
        jmsSupport.createConsumer((Session)mockSession.proxy(), (Destination)topic, null, noLocal, durableName, true);
        mockTopic.verify();
        mockSession.verify();
    }

    public void testNoLocalCalledForNonDurableTopic() throws Exception {
        Jms11Support jmsSupport = new Jms11Support(new JmsConnector(), null, false, false);
        Mock mockTopic = new Mock(Topic.class);
        Topic topic = (Topic)mockTopic.proxy();
        boolean noLocal = true;
        FullConstraintMatcher matcher = new FullConstraintMatcher(new Constraint[]{C.eq((Object)topic), C.IS_NULL, C.IS_TRUE});
        Mock mockSession = new Mock(Session.class);
        mockSession.expect("createConsumer", (ConstraintMatcher)matcher);
        jmsSupport.createConsumer((Session)mockSession.proxy(), (Destination)topic, null, noLocal, null, true);
        mockTopic.verify();
        mockSession.verify();
    }

    public void testNoLocalNotCalledForQueue() throws Exception {
        Jms11Support jmsSupport = new Jms11Support(new JmsConnector(), null, false, false);
        Mock mockQueue = new Mock(Queue.class);
        Queue queue = (Queue)mockQueue.proxy();
        boolean noLocal = true;
        FullConstraintMatcher matcher = new FullConstraintMatcher(new Constraint[]{C.eq((Object)queue), C.IS_NULL});
        Mock mockSession = new Mock(Session.class);
        mockSession.expect("createConsumer", (ConstraintMatcher)matcher);
        jmsSupport.createConsumer((Session)mockSession.proxy(), (Destination)queue, null, noLocal, null, false);
        mockQueue.verify();
        mockSession.verify();
    }

    public void testDurableWithQueueThrowsException() throws Exception {
        Jms11Support jmsSupport = new Jms11Support(new JmsConnector(), null, false, false);
        Mock mockQueue = new Mock(Queue.class);
        Queue queue = (Queue)mockQueue.proxy();
        String durableName = "durableName";
        boolean noLocal = true;
        Mock mockSession = new Mock(Session.class);
        try {
            jmsSupport.createConsumer((Session)mockSession.proxy(), (Destination)queue, null, noLocal, durableName, false);
        }
        catch (JMSException jmsex) {
            Jms11SupportTestCase.assertEquals((String)"Wrong exception text.", (String)"A durable subscriber name was set but the destination was not a Topic", (String)jmsex.getMessage());
        }
        mockQueue.verify();
        mockSession.verify();
    }
}

