/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms.activemq;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jms.Connection;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.mule.providers.jms.DefaultJmsTopicResolver;
import org.mule.providers.jms.JmsTopicResolver;
import org.mule.providers.jms.activemq.ActiveMqJmsConnector;
import org.mule.providers.jms.xa.ConnectionFactoryWrapper;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.mule.TestTransactionManagerFactory;

public class ActiveMqJmsConnectorTestCase
extends AbstractMuleTestCase {
    public void testConfigurationDefaults() {
        ActiveMqJmsConnector c = new ActiveMqJmsConnector();
        ActiveMqJmsConnectorTestCase.assertFalse((boolean)c.isEagerConsumer());
        JmsTopicResolver resolver = c.getTopicResolver();
        ActiveMqJmsConnectorTestCase.assertNotNull((String)"Topic resolver must not be null.", (Object)resolver);
        ActiveMqJmsConnectorTestCase.assertTrue((String)"Wrong topic resolver configured on the connector.", (boolean)(resolver instanceof DefaultJmsTopicResolver));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReflectiveXaCleanup() throws Exception {
        ActiveMQXAConnectionFactory factory = new ActiveMQXAConnectionFactory("vm://localhost?broker.persistent=false&broker.useJmx=false");
        ConnectionFactoryWrapper wrapper = new ConnectionFactoryWrapper((Object)factory, new TestTransactionManagerFactory().create());
        Connection connection = wrapper.createConnection();
        ActiveMqJmsConnectorTestCase.assertNotNull((Object)connection);
        ActiveMqJmsConnectorTestCase.assertTrue((boolean)Proxy.isProxyClass(connection.getClass()));
        try {
            Method cleanupMethod;
            Class<?> clazz = connection.getClass();
            if (Proxy.isProxyClass(clazz)) {
                ConnectionFactoryWrapper.ConnectionInvocationHandler handler = (ConnectionFactoryWrapper.ConnectionInvocationHandler)Proxy.getInvocationHandler(connection);
                connection = (Connection)handler.getTargetObject();
                Class<?> realConnectionClass = connection.getClass();
                cleanupMethod = realConnectionClass.getMethod("cleanup", null);
            } else {
                cleanupMethod = clazz.getMethod("cleanup", null);
            }
            if (cleanupMethod != null) {
                cleanupMethod.invoke((Object)connection, null);
            }
        }
        finally {
            connection.close();
        }
    }
}

