/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import java.util.ArrayList;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import javax.resource.spi.work.Work;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.AbstractReceiverWorker;
import org.mule.providers.ConnectException;
import org.mule.providers.jms.JmsClientAcknowledgeTransaction;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.JmsSupport;
import org.mule.providers.jms.JmsTransaction;
import org.mule.providers.jms.RedeliveryHandler;
import org.mule.providers.jms.filters.JmsSelectorFilter;
import org.mule.umo.TransactionException;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.LifecycleException;
import org.mule.umo.provider.UMOConnector;
import org.mule.util.ClassUtils;

public class JmsMessageReceiver
extends AbstractMessageReceiver
implements MessageListener {
    protected JmsConnector connector;
    protected RedeliveryHandler redeliveryHandler;
    protected MessageConsumer consumer;
    protected Session session;
    protected boolean startOnConnect = false;

    public JmsMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
        this.connector = (JmsConnector)connector;
        try {
            this.redeliveryHandler = this.connector.createRedeliveryHandler();
            this.redeliveryHandler.setConnector(this.connector);
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Object)this);
        }
    }

    protected void doConnect() throws Exception {
        this.createConsumer();
        if (this.startOnConnect) {
            this.doStart();
        }
    }

    protected void doDisconnect() throws Exception {
        this.closeConsumer();
    }

    public void onMessage(Message message) {
        try {
            this.getWorkManager().scheduleWork((Work)new JmsWorker(message, (AbstractMessageReceiver)this));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void doStart() throws UMOException {
        try {
            if (this.consumer == null) {
                this.startOnConnect = true;
            } else {
                this.startOnConnect = false;
                this.consumer.setMessageListener((MessageListener)this);
            }
        }
        catch (JMSException e) {
            throw new LifecycleException((Throwable)e, (Object)this);
        }
    }

    protected void doStop() throws UMOException {
        try {
            if (this.consumer != null) {
                this.consumer.setMessageListener(null);
            }
        }
        catch (JMSException e) {
            throw new LifecycleException((Throwable)e, (Object)this);
        }
    }

    protected void doDispose() {
    }

    protected void closeConsumer() {
        this.connector.closeQuietly(this.consumer);
        this.consumer = null;
        this.connector.closeQuietly(this.session);
        this.session = null;
    }

    protected void createConsumer() throws Exception {
        try {
            String durableName;
            JmsSupport jmsSupport = this.connector.getJmsSupport();
            if (this.session == null) {
                this.session = this.connector.getSession((UMOImmutableEndpoint)this.endpoint);
            }
            boolean topic = this.connector.getTopicResolver().isTopic((UMOImmutableEndpoint)this.endpoint, true);
            Destination dest = jmsSupport.createDestination(this.session, this.endpoint.getEndpointURI().getAddress(), topic);
            String selector = null;
            if (this.endpoint.getFilter() != null && this.endpoint.getFilter() instanceof JmsSelectorFilter) {
                selector = ((JmsSelectorFilter)this.endpoint.getFilter()).getExpression();
            } else if (this.endpoint.getProperties() != null) {
                selector = (String)this.endpoint.getProperties().get("selector");
            }
            String tempDurable = (String)this.endpoint.getProperties().get("durable");
            boolean durable = this.connector.isDurable();
            if (tempDurable != null) {
                durable = Boolean.valueOf(tempDurable);
            }
            if ((durableName = (String)this.endpoint.getProperties().get("durableName")) == null && durable && dest instanceof Topic) {
                durableName = "mule." + this.connector.getName() + "." + this.endpoint.getEndpointURI().getAddress();
                this.logger.debug((Object)("Jms Connector for this receiver is durable but no durable name has been specified. Defaulting to: " + durableName));
            }
            this.consumer = jmsSupport.createConsumer(this.session, dest, selector, this.connector.isNoLocal(), durableName, topic);
        }
        catch (JMSException e) {
            throw new ConnectException((Throwable)e, (Object)this);
        }
    }

    protected class JmsWorker
    extends AbstractReceiverWorker {
        public JmsWorker(Message message, AbstractMessageReceiver receiver) {
            super(new ArrayList(1), receiver);
            this.messages.add(message);
        }

        public JmsWorker(List messages, AbstractMessageReceiver receiver) {
            super(messages, receiver);
        }

        protected Object preProcessMessage(Object message) throws Exception {
            Message m = (Message)message;
            if (JmsMessageReceiver.this.logger.isDebugEnabled()) {
                JmsMessageReceiver.this.logger.debug((Object)("Message received it is of type: " + ClassUtils.getSimpleName(message.getClass())));
                if (m.getJMSDestination() != null) {
                    JmsMessageReceiver.this.logger.debug((Object)("Message received on " + m.getJMSDestination() + " (" + m.getJMSDestination().getClass().getName() + ")"));
                } else {
                    JmsMessageReceiver.this.logger.debug((Object)"Message received on unknown destination");
                }
                JmsMessageReceiver.this.logger.debug((Object)("Message CorrelationId is: " + m.getJMSCorrelationID()));
                JmsMessageReceiver.this.logger.debug((Object)("Jms Message Id is: " + m.getJMSMessageID()));
            }
            if (m.getJMSRedelivered() && JmsMessageReceiver.this.redeliveryHandler != null) {
                if (JmsMessageReceiver.this.logger.isDebugEnabled()) {
                    JmsMessageReceiver.this.logger.debug((Object)("Message with correlationId: " + m.getJMSCorrelationID() + " has redelivered flag set, handing off to Exception Handler"));
                }
                JmsMessageReceiver.this.redeliveryHandler.handleRedelivery(m);
            }
            return m;
        }

        protected void bindTransaction(UMOTransaction tx) throws TransactionException {
            if (tx instanceof JmsTransaction) {
                tx.bindResource((Object)JmsMessageReceiver.this.connector.getConnection(), (Object)JmsMessageReceiver.this.session);
            } else if (tx instanceof JmsClientAcknowledgeTransaction) {
                tx.bindResource((Object)JmsMessageReceiver.this.connector.getConnection(), (Object)JmsMessageReceiver.this.session);
                ((JmsClientAcknowledgeTransaction)tx).setMessage((Message)this.messages.get(0));
            }
        }
    }
}

