/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import javax.resource.spi.work.Work;
import org.apache.commons.logging.Log;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.ConnectException;
import org.mule.providers.jms.JmsClientAcknowledgeTransaction;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.JmsSupport;
import org.mule.providers.jms.MessageTransactionCallback;
import org.mule.providers.jms.RedeliveryHandler;
import org.mule.providers.jms.filters.JmsSelectorFilter;
import org.mule.transaction.TransactionCallback;
import org.mule.transaction.TransactionCoordination;
import org.mule.transaction.TransactionTemplate;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.LifecycleException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.util.ClassUtils;

public class TransactedSingleResourceJmsMessageReceiver
extends AbstractMessageReceiver
implements MessageListener {
    protected JmsConnector connector;
    protected RedeliveryHandler redeliveryHandler;
    protected MessageConsumer consumer;
    protected Session session;
    protected boolean startOnConnect = false;
    protected boolean receiveMessagesInTransaction = true;
    protected boolean useMultipleReceivers = true;

    public TransactedSingleResourceJmsMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
        this.connector = (JmsConnector)connector;
        try {
            this.redeliveryHandler = this.connector.createRedeliveryHandler();
            this.redeliveryHandler.setConnector(this.connector);
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Object)this);
        }
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
        try {
            String durableName;
            JmsSupport jmsSupport = this.connector.getJmsSupport();
            if (this.session == null) {
                this.session = this.connector.getSession((UMOImmutableEndpoint)this.endpoint);
            }
            boolean topic = this.connector.getTopicResolver().isTopic((UMOImmutableEndpoint)this.endpoint, true);
            Destination dest = jmsSupport.createDestination(this.session, this.endpoint.getEndpointURI().getAddress(), topic);
            String selector = null;
            if (this.endpoint.getFilter() != null && this.endpoint.getFilter() instanceof JmsSelectorFilter) {
                selector = ((JmsSelectorFilter)this.endpoint.getFilter()).getExpression();
            } else if (this.endpoint.getProperties() != null) {
                selector = (String)this.endpoint.getProperties().get("selector");
            }
            String tempDurable = (String)this.endpoint.getProperties().get("durable");
            boolean durable = this.connector.isDurable();
            if (tempDurable != null) {
                durable = Boolean.valueOf(tempDurable);
            }
            if ((durableName = (String)this.endpoint.getProperties().get("durableName")) == null && durable && dest instanceof Topic) {
                durableName = "mule." + this.connector.getName() + "." + this.endpoint.getEndpointURI().getAddress();
                this.logger.debug((Object)("Jms Connector for this receiver is durable but no durable name has been specified. Defaulting to: " + durableName));
            }
            this.consumer = jmsSupport.createConsumer(this.session, dest, selector, this.connector.isNoLocal(), durableName, topic);
        }
        catch (JMSException e) {
            throw new ConnectException((Throwable)e, (Object)this);
        }
    }

    protected void doStart() throws UMOException {
        try {
            if (this.consumer == null) {
                this.startOnConnect = true;
            } else {
                this.startOnConnect = false;
                this.consumer.setMessageListener((MessageListener)this);
            }
        }
        catch (JMSException e) {
            throw new LifecycleException((Throwable)e, (Object)this);
        }
    }

    protected void doStop() throws UMOException {
        try {
            if (this.consumer != null) {
                this.consumer.setMessageListener(null);
            }
        }
        catch (JMSException e) {
            throw new LifecycleException((Throwable)e, (Object)this);
        }
    }

    public void doDisconnect() throws Exception {
        this.closeConsumer();
    }

    protected void closeConsumer() {
        this.connector.closeQuietly(this.consumer);
        this.consumer = null;
        this.connector.closeQuietly(this.session);
        this.session = null;
    }

    public void onMessage(Message message) {
        try {
            this.getWorkManager().scheduleWork((Work)new MessageReceiverWorker(message));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    static /* synthetic */ Log access$200(TransactedSingleResourceJmsMessageReceiver x0) {
        return x0.logger;
    }

    static /* synthetic */ Log access$300(TransactedSingleResourceJmsMessageReceiver x0) {
        return x0.logger;
    }

    static /* synthetic */ Log access$400(TransactedSingleResourceJmsMessageReceiver x0) {
        return x0.logger;
    }

    static /* synthetic */ Log access$500(TransactedSingleResourceJmsMessageReceiver x0) {
        return x0.logger;
    }

    static /* synthetic */ Log access$600(TransactedSingleResourceJmsMessageReceiver x0) {
        return x0.logger;
    }

    static /* synthetic */ Log access$700(TransactedSingleResourceJmsMessageReceiver x0) {
        return x0.logger;
    }

    static /* synthetic */ Log access$800(TransactedSingleResourceJmsMessageReceiver x0) {
        return x0.logger;
    }

    static /* synthetic */ Log access$900(TransactedSingleResourceJmsMessageReceiver x0) {
        return x0.logger;
    }

    protected class MessageReceiverWorker
    implements Work {
        Message message;

        public MessageReceiverWorker(Message message) {
            this.message = message;
        }

        public void run() {
            try {
                TransactionTemplate tt = new TransactionTemplate(TransactedSingleResourceJmsMessageReceiver.this.endpoint.getTransactionConfig(), TransactedSingleResourceJmsMessageReceiver.this.connector.getExceptionListener());
                if (TransactedSingleResourceJmsMessageReceiver.this.receiveMessagesInTransaction) {
                    MessageTransactionCallback cb = new MessageTransactionCallback(this, this.message){
                        private final /* synthetic */ MessageReceiverWorker this$1;
                        {
                            this.this$1 = this$1;
                            super(x0);
                        }

                        public Object doInTransaction() throws Exception {
                            UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
                            if (tx != null) {
                                tx.bindResource((Object)MessageReceiverWorker.access$100((MessageReceiverWorker)this.this$1).connector.getConnection(), (Object)MessageReceiverWorker.access$100((MessageReceiverWorker)this.this$1).session);
                            }
                            if (tx instanceof JmsClientAcknowledgeTransaction) {
                                tx.bindResource((Object)this.message, (Object)this.message);
                            }
                            if (TransactedSingleResourceJmsMessageReceiver.access$200(MessageReceiverWorker.access$100(this.this$1)).isDebugEnabled()) {
                                TransactedSingleResourceJmsMessageReceiver.access$300(MessageReceiverWorker.access$100(this.this$1)).debug((Object)("Message received it is of type: " + ClassUtils.getSimpleName(this.message.getClass())));
                                if (this.message.getJMSDestination() != null) {
                                    TransactedSingleResourceJmsMessageReceiver.access$400(MessageReceiverWorker.access$100(this.this$1)).debug((Object)("Message received on " + this.message.getJMSDestination() + " (" + this.message.getJMSDestination().getClass().getName() + ")"));
                                } else {
                                    TransactedSingleResourceJmsMessageReceiver.access$500(MessageReceiverWorker.access$100(this.this$1)).debug((Object)"Message received on unknown destination");
                                }
                                TransactedSingleResourceJmsMessageReceiver.access$600(MessageReceiverWorker.access$100(this.this$1)).debug((Object)("Message CorrelationId is: " + this.message.getJMSCorrelationID()));
                                TransactedSingleResourceJmsMessageReceiver.access$700(MessageReceiverWorker.access$100(this.this$1)).debug((Object)("Jms Message Id is: " + this.message.getJMSMessageID()));
                            }
                            if (this.message.getJMSRedelivered()) {
                                if (TransactedSingleResourceJmsMessageReceiver.access$800(MessageReceiverWorker.access$100(this.this$1)).isDebugEnabled()) {
                                    TransactedSingleResourceJmsMessageReceiver.access$900(MessageReceiverWorker.access$100(this.this$1)).debug((Object)("Message with correlationId: " + this.message.getJMSCorrelationID() + " is redelivered. handing off to Exception Handler"));
                                }
                                MessageReceiverWorker.access$100((MessageReceiverWorker)this.this$1).redeliveryHandler.handleRedelivery(this.message);
                            }
                            UMOMessageAdapter adapter = MessageReceiverWorker.access$100((MessageReceiverWorker)this.this$1).connector.getMessageAdapter(this.message);
                            MessageReceiverWorker.access$100(this.this$1).routeMessage((UMOMessage)new MuleMessage((Object)adapter));
                            return null;
                        }
                    };
                    tt.execute((TransactionCallback)cb);
                } else {
                    UMOMessageAdapter adapter = TransactedSingleResourceJmsMessageReceiver.this.connector.getMessageAdapter(this.message);
                    TransactedSingleResourceJmsMessageReceiver.this.routeMessage((UMOMessage)new MuleMessage((Object)adapter));
                }
            }
            catch (Exception e) {
                TransactedSingleResourceJmsMessageReceiver.this.getConnector().handleException(e);
            }
        }

        public void release() {
        }

        static /* synthetic */ TransactedSingleResourceJmsMessageReceiver access$100(MessageReceiverWorker x0) {
            return x0.TransactedSingleResourceJmsMessageReceiver.this;
        }
    }
}

