/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms.transformers;

import java.util.Iterator;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.mule.impl.RequestContext;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.JmsConstants;
import org.mule.providers.jms.JmsMessageUtils;
import org.mule.transformers.AbstractTransformer;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.ClassUtils;

public abstract class AbstractJmsTransformer
extends AbstractTransformer {
    protected Message transformToMessage(Object src) throws TransformerException {
        try {
            Message result;
            if (src instanceof Message) {
                result = (Message)src;
                result.clearProperties();
            } else {
                result = JmsMessageUtils.toMessage(src, this.getSession());
            }
            UMOEventContext ctx = RequestContext.getEventContext();
            if (ctx == null) {
                this.logger.warn((Object)"There is no current event context");
                return result;
            }
            this.setJmsProperties(ctx.getMessage(), result);
            return result;
        }
        catch (TransformerException tex) {
            throw tex;
        }
        catch (Exception e) {
            throw new TransformerException((UMOTransformer)this, (Throwable)e);
        }
    }

    protected Object transformFromMessage(Message source) throws TransformerException {
        try {
            UMOConnector connector;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Message type received is: " + ClassUtils.getSimpleName(source.getClass())));
            }
            String jmsSpec = "1.0.2b";
            UMOImmutableEndpoint endpoint = this.getEndpoint();
            if (endpoint != null && (connector = endpoint.getConnector()) instanceof JmsConnector) {
                jmsSpec = ((JmsConnector)connector).getSpecification();
            }
            return JmsMessageUtils.toObject(source, jmsSpec);
        }
        catch (Exception e) {
            throw new TransformerException((UMOTransformer)this, (Throwable)e);
        }
    }

    protected void setJmsProperties(UMOMessage umoMessage, Message msg) throws JMSException {
        Iterator iterator = umoMessage.getPropertyNames().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            if (JmsConstants.JMS_PROPERTY_NAMES.contains(key)) continue;
            Object value = umoMessage.getProperty(key);
            if ("MULE_CORRELATION_ID".equals(key)) {
                msg.setJMSCorrelationID(umoMessage.getCorrelationId());
            }
            if ("MULE_REPLYTO".equals(key) && value instanceof Destination) continue;
            key = JmsMessageUtils.encodeHeader(key);
            try {
                msg.setObjectProperty(key, value);
            }
            catch (JMSException e) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Unable to set property '" + key + "' of type " + ClassUtils.getSimpleName(value.getClass()) + "': " + e.getMessage()));
            }
        }
    }

    protected Session getSession() throws TransformerException, JMSException {
        if (this.endpoint != null) {
            return ((JmsConnector)this.endpoint.getConnector()).getSession(this.endpoint);
        }
        throw new TransformerException((UMOTransformer)this, (Throwable)new IllegalStateException("This transformer needs a valid endpoint"));
    }
}

