/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import com.mockobjects.dynamic.Mock;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Topic;
import org.mule.providers.jms.DefaultJmsTopicResolver;
import org.mule.providers.jms.JmsConnector;
import org.mule.tck.FunctionalTestCase;
import org.mule.umo.endpoint.UMOImmutableEndpoint;

public class DefaultJmsTopicResolverTestCase
extends FunctionalTestCase {
    private JmsConnector connector;
    private DefaultJmsTopicResolver resolver;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.connector = (JmsConnector)managementContext.getRegistry().lookupConnector("jmsConnector");
        this.resolver = (DefaultJmsTopicResolver)this.connector.getTopicResolver();
    }

    protected String getConfigResources() {
        return "jms-topic-resolver.xml";
    }

    public void testSameConnector() {
        DefaultJmsTopicResolverTestCase.assertSame((Object)this.connector, (Object)this.resolver.getConnector());
    }

    public void testEndpointNotTopicNoFallback() throws Exception {
        UMOImmutableEndpoint endpoint = managementContext.getRegistry().lookupEndpoint("ep1");
        DefaultJmsTopicResolverTestCase.assertFalse((boolean)this.resolver.isTopic(endpoint));
    }

    public void testEndpointTopicNoFallback() throws Exception {
        UMOImmutableEndpoint endpoint = managementContext.getRegistry().lookupEndpoint("ep2");
        DefaultJmsTopicResolverTestCase.assertTrue((boolean)this.resolver.isTopic(endpoint));
    }

    public void testEndpointNotTopicWithFallback() throws Exception {
        UMOImmutableEndpoint endpoint = managementContext.getRegistry().lookupEndpoint("ep3");
        DefaultJmsTopicResolverTestCase.assertTrue((boolean)this.resolver.isTopic(endpoint, true));
    }

    public void testEndpointTopicFallbackNotUsed() throws Exception {
        UMOImmutableEndpoint endpoint = managementContext.getRegistry().lookupEndpoint("ep4");
        DefaultJmsTopicResolverTestCase.assertTrue((boolean)this.resolver.isTopic(endpoint, true));
    }

    public void testDestinationNotTopic() throws Exception {
        Mock mock = new Mock(Queue.class);
        Queue queue = (Queue)mock.proxy();
        DefaultJmsTopicResolverTestCase.assertFalse((boolean)this.resolver.isTopic((Destination)queue));
        mock.verify();
    }

    public void testDestinationTopic() throws Exception {
        Mock mock = new Mock(Topic.class);
        Topic topic = (Topic)mock.proxy();
        DefaultJmsTopicResolverTestCase.assertTrue((boolean)this.resolver.isTopic((Destination)topic));
        mock.verify();
    }
}

