/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import javax.jms.ConnectionFactory;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.test.TestConnectionFactory;
import org.mule.tck.FunctionalTestCase;

public class JmsConnectionFactoryTestCase
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "jms-connection-factory.xml";
    }

    public void testProviderPropertiesNotPassed() throws Exception {
        JmsConnector c = (JmsConnector)managementContext.getRegistry().lookupConnector("jmsConnector1");
        JmsConnectionFactoryTestCase.assertNotNull((Object)c);
        ConnectionFactory cf = (ConnectionFactory)c.getConnectionFactory().getOrCreate();
        JmsConnectionFactoryTestCase.assertTrue((boolean)(cf instanceof TestConnectionFactory));
        JmsConnectionFactoryTestCase.assertEquals((String)"Provider properties should not be passed to the ConnectionFactory.", (String)"NOT_SET", (String)((TestConnectionFactory)cf).getProviderProperty());
    }

    public void testConnectionFactoryPropertiesPassed() throws Exception {
        JmsConnector c = (JmsConnector)managementContext.getRegistry().lookupConnector("jmsConnector2");
        JmsConnectionFactoryTestCase.assertNotNull((Object)c);
        ConnectionFactory cf = (ConnectionFactory)c.getConnectionFactory().getOrCreate();
        JmsConnectionFactoryTestCase.assertTrue((boolean)(cf instanceof TestConnectionFactory));
        JmsConnectionFactoryTestCase.assertEquals((String)"ConnectionFactory properties should be passed to the ConnectionFactory.", (String)"TEST_VALUE", (String)((TestConnectionFactory)cf).getConnectionFactoryProperty());
    }
}

