/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.tck.AbstractMuleTestCase;

public class JmsEndpointTestCase
extends AbstractMuleTestCase {
    public void testWithoutFullUrl() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jms:/my.queue");
        url.initialise();
        JmsEndpointTestCase.assertEquals((String)"jms", (String)url.getScheme());
        JmsEndpointTestCase.assertEquals((String)"my.queue", (String)url.getAddress());
        JmsEndpointTestCase.assertNull((Object)url.getEndpointName());
        JmsEndpointTestCase.assertEquals((String)"jms:/my.queue", (String)url.toString());
    }

    public void testFullUrlWithSlashes() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jms://my/queue");
        url.initialise();
        JmsEndpointTestCase.assertEquals((String)"jms", (String)url.getScheme());
        JmsEndpointTestCase.assertEquals((String)"my/queue", (String)url.getAddress());
        JmsEndpointTestCase.assertNull((Object)url.getEndpointName());
        JmsEndpointTestCase.assertEquals((String)"jms://my/queue", (String)url.toString());
    }

    public void testWithoutFullUrlAndEndpointName() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jms:/my.queue?endpointName=jmsProvider");
        url.initialise();
        JmsEndpointTestCase.assertEquals((String)"jms", (String)url.getScheme());
        JmsEndpointTestCase.assertEquals((String)"my.queue", (String)url.getAddress());
        JmsEndpointTestCase.assertNotNull((Object)url.getEndpointName());
        JmsEndpointTestCase.assertEquals((String)"jmsProvider", (String)url.getEndpointName());
        JmsEndpointTestCase.assertEquals((String)"jms:/my.queue?endpointName=jmsProvider", (String)url.toString());
    }

    public void testJmsUrl() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jms://queue1?endpointName=jmsProvider");
        url.initialise();
        JmsEndpointTestCase.assertEquals((String)"jms", (String)url.getScheme());
        JmsEndpointTestCase.assertEquals((String)"queue1", (String)url.getAddress());
        JmsEndpointTestCase.assertEquals((String)"jmsProvider", (String)url.getEndpointName());
        JmsEndpointTestCase.assertEquals((String)"jms://queue1?endpointName=jmsProvider", (String)url.toString());
    }

    public void testJmsTopic() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jms://topic:topic1");
        url.initialise();
        JmsEndpointTestCase.assertEquals((String)"jms", (String)url.getScheme());
        JmsEndpointTestCase.assertEquals((String)"topic1", (String)url.getAddress());
        JmsEndpointTestCase.assertEquals((String)"topic", (String)url.getResourceInfo());
        JmsEndpointTestCase.assertEquals(null, (String)url.getEndpointName());
        JmsEndpointTestCase.assertEquals((String)"jms://topic:topic1", (String)url.toString());
    }

    public void testJmsTopicWithProvider() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jms://topic:topic1?endpointName=jmsProvider");
        url.initialise();
        JmsEndpointTestCase.assertEquals((String)"jms", (String)url.getScheme());
        JmsEndpointTestCase.assertEquals((String)"topic1", (String)url.getAddress());
        JmsEndpointTestCase.assertEquals((String)"jmsProvider", (String)url.getEndpointName());
        JmsEndpointTestCase.assertEquals((String)"topic", (String)url.getResourceInfo());
        JmsEndpointTestCase.assertEquals((String)"jms://topic:topic1?endpointName=jmsProvider", (String)url.toString());
    }

    public void testJmsTopicWithUserInfo() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jms://user:password@topic:topic1");
        url.initialise();
        JmsEndpointTestCase.assertEquals((String)"jms", (String)url.getScheme());
        JmsEndpointTestCase.assertEquals((String)"topic1", (String)url.getAddress());
        JmsEndpointTestCase.assertEquals((String)"topic", (String)url.getResourceInfo());
        JmsEndpointTestCase.assertEquals((String)"user:password", (String)url.getUserInfo());
        JmsEndpointTestCase.assertEquals((String)"user", (String)url.getUsername());
        JmsEndpointTestCase.assertEquals((String)"password", (String)url.getPassword());
        JmsEndpointTestCase.assertEquals((String)"jms://user:password@topic:topic1", (String)url.toString());
    }

    public void testJmsTopicWithUserInfoAndProvider() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jms://user:password@topic:topic1?endpointName=jmsProvider");
        url.initialise();
        JmsEndpointTestCase.assertEquals((String)"jms", (String)url.getScheme());
        JmsEndpointTestCase.assertEquals((String)"topic1", (String)url.getAddress());
        JmsEndpointTestCase.assertEquals((String)"jmsProvider", (String)url.getEndpointName());
        JmsEndpointTestCase.assertEquals((String)"topic", (String)url.getResourceInfo());
        JmsEndpointTestCase.assertEquals((String)"user:password", (String)url.getUserInfo());
        JmsEndpointTestCase.assertEquals((String)"user", (String)url.getUsername());
        JmsEndpointTestCase.assertEquals((String)"password", (String)url.getPassword());
        JmsEndpointTestCase.assertEquals((String)"jms://user:password@topic:topic1?endpointName=jmsProvider", (String)url.toString());
    }

    public void testJmsDestWithSlashesAndUserInfoUsingAddressParam() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jms://user:password@?address=/myQueues/myQueue&createConnector=ALWAYS");
        url.initialise();
        JmsEndpointTestCase.assertEquals((String)"jms", (String)url.getScheme());
        JmsEndpointTestCase.assertEquals((String)"/myQueues/myQueue", (String)url.getAddress());
        JmsEndpointTestCase.assertEquals((String)"user:password", (String)url.getUserInfo());
        JmsEndpointTestCase.assertEquals((String)"user", (String)url.getUsername());
        JmsEndpointTestCase.assertEquals((String)"password", (String)url.getPassword());
        JmsEndpointTestCase.assertEquals((int)1, (int)url.getCreateConnector());
        JmsEndpointTestCase.assertEquals((String)"jms://user:password@?address=/myQueues/myQueue&createConnector=ALWAYS", (String)url.toString());
    }

    public void testJmsDestWithSlashesAndUserInfo() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jms://user:password@myQueues/myQueue?createConnector=ALWAYS");
        url.initialise();
        JmsEndpointTestCase.assertEquals((String)"jms", (String)url.getScheme());
        JmsEndpointTestCase.assertEquals((String)"myQueues/myQueue", (String)url.getAddress());
        JmsEndpointTestCase.assertEquals((String)"user:password", (String)url.getUserInfo());
        JmsEndpointTestCase.assertEquals((String)"user", (String)url.getUsername());
        JmsEndpointTestCase.assertEquals((String)"password", (String)url.getPassword());
        JmsEndpointTestCase.assertEquals((int)1, (int)url.getCreateConnector());
        JmsEndpointTestCase.assertEquals((String)"jms://user:password@myQueues/myQueue?createConnector=ALWAYS", (String)url.toString());
    }
}

