/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import com.mockobjects.dynamic.AnyConstraintMatcher;
import com.mockobjects.dynamic.ConstraintMatcher;
import com.mockobjects.dynamic.Mock;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import org.mule.config.i18n.MessageFactory;
import org.mule.impl.endpoint.EndpointURIEndpointBuilder;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.JmsConnectorTestCase;
import org.mule.providers.jms.JmsMessageReceiver;
import org.mule.tck.providers.AbstractMessageReceiverTestCase;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.umo.endpoint.UMOEndpointBuilder;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.util.object.ObjectFactory;
import org.mule.util.object.SingletonObjectFactory;

public class JmsMessageReceiverTestCase
extends AbstractMessageReceiverTestCase {
    private JmsConnector connector;

    protected void doSetUp() throws Exception {
        this.connector = new JmsConnector();
        this.connector.setName("TestConnector");
        this.connector.setSpecification("1.1");
        Mock connectionFactory = new Mock(ConnectionFactory.class);
        Mock connection = new Mock(Connection.class);
        connectionFactory.expectAndReturn("createConnection", connection.proxy());
        connection.expect("setExceptionListener", (ConstraintMatcher)new AnyConstraintMatcher());
        connection.expect("close");
        connection.expect("start");
        connection.expect("stop");
        this.connector.setConnectionFactory((ObjectFactory)new SingletonObjectFactory(connectionFactory.proxy()));
        this.connector.setManagementContext(managementContext);
        managementContext.applyLifecycle((Object)this.connector);
        managementContext.getRegistry().registerConnector((UMOConnector)this.connector, managementContext);
        super.doSetUp();
    }

    public void testReceive() throws Exception {
        JmsMessageReceiver receiver = (JmsMessageReceiver)this.getMessageReceiver();
        JmsMessageReceiverTestCase.assertNotNull((Object)receiver.getComponent());
        JmsMessageReceiverTestCase.assertNotNull((Object)receiver.getConnector());
        JmsMessageReceiverTestCase.assertNotNull((Object)receiver.getEndpoint());
    }

    public UMOMessageReceiver getMessageReceiver() throws Exception {
        return new JmsMessageReceiver(this.endpoint.getConnector(), JmsMessageReceiverTestCase.getTestComponent((String)"orange", (Class)Orange.class), this.endpoint);
    }

    public Object getValidMessage() throws Exception {
        return JmsConnectorTestCase.getMessage();
    }

    public UMOImmutableEndpoint getEndpoint() throws Exception {
        EndpointURIEndpointBuilder builder = new EndpointURIEndpointBuilder("jms://testcase", managementContext);
        if (this.connector == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)"Connector has not been initialized."), null);
        }
        builder.setConnector((UMOConnector)this.connector);
        this.endpoint = managementContext.getRegistry().lookupEndpointFactory().createInboundEndpoint((UMOEndpointBuilder)builder, managementContext);
        return this.endpoint;
    }
}

