/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms.functional;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueConnection;
import javax.jms.TextMessage;
import javax.jms.TopicConnection;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.test.JmsTestUtils;
import org.mule.tck.FunctionalTestCase;
import org.mule.umo.provider.UMOConnector;
import org.mule.util.concurrent.Latch;

public abstract class AbstractJmsFunctionalTestCase
extends FunctionalTestCase {
    public static final String DEFAULT_IN_QUEUE = "jms://in.q";
    public static final String DEFAULT_OUT_QUEUE = "jms://out.q";
    public static final String DEFAULT_DL_QUEUE = "jms://dlq";
    public static final String DEFAULT_IN_TOPIC = "jms://topic:in.t";
    public static final String DEFAULT_OUT_TOPIC = "jms://topic:out.t";
    public static final String DEFAULT_DL_TOPIC = "jms://topic:dlt";
    public static final String DEFAULT_MESSAGE = "Test Message";
    public static final String CONNECTOR_NAME = "testConnector";
    public static final long JMS_TIMEOUT = 10000L;
    protected JmsConnector connector;
    protected Connection connection;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        if (this.connector == null) {
            this.connector = this.lookupConnector();
        }
        this.callbackCalled = new Latch();
        this.connection = this.getSenderConnection();
        this.connection.start();
    }

    protected void doTearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public Connection getSenderConnection() throws Exception {
        ConnectionFactory cf = (ConnectionFactory)this.connector.getConnectionFactory().getOrCreate();
        return cf.createConnection();
    }

    protected void send(String payload, String dest) throws JMSException {
        this.send(payload, dest, false, this.getAcknowledgementMode(), null);
    }

    protected void send(String payload, String dest, boolean transacted, int ack, String replyTo) throws JMSException {
        if (this.useTopics()) {
            JmsTestUtils.topicPublish((TopicConnection)this.connection, dest, payload, transacted, ack, replyTo);
        } else {
            JmsTestUtils.queueSend((QueueConnection)this.connection, dest, payload, transacted, ack, replyTo);
        }
    }

    protected String receiveTextMessage(String dest) throws JMSException {
        return this.receiveTextMessage(dest, 10000L);
    }

    protected String receiveTextMessage(String dest, long timeout) throws JMSException {
        Message output = this.receive(dest, timeout);
        AbstractJmsFunctionalTestCase.assertNotNull((Object)output);
        AbstractJmsFunctionalTestCase.assertTrue((boolean)(output instanceof TextMessage));
        return ((TextMessage)output).getText();
    }

    protected Message receive(String dest) throws JMSException {
        return this.receive(dest, 10000L);
    }

    protected Message receive(String dest, long timeout) throws JMSException {
        Message msg = null;
        msg = this.useTopics() ? JmsTestUtils.topicSubscribe((TopicConnection)this.connection, dest, timeout) : JmsTestUtils.queueReceiver((QueueConnection)this.connection, dest, timeout);
        return msg;
    }

    public boolean useTopics() {
        return false;
    }

    protected int getAcknowledgementMode() {
        return 1;
    }

    private JmsConnector lookupConnector() {
        UMOConnector connector = managementContext.getRegistry().lookupConnector("jmsConnector");
        AbstractJmsFunctionalTestCase.assertNotNull((String)"Connector not found in config", (Object)connector);
        AbstractJmsFunctionalTestCase.assertTrue((String)"Connector is not a JmsConnector", (boolean)(connector instanceof JmsConnector));
        return (JmsConnector)connector;
    }
}

