/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms.functional;

import org.mule.providers.jms.functional.AbstractJmsFunctionalTestCase;
import org.mule.tck.functional.CountdownCallback;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.umo.UMOException;

public abstract class AbstractJmsQueueFunctionalTestCase
extends AbstractJmsFunctionalTestCase {
    protected String getConfigResources() {
        return "jms-functional-test.xml";
    }

    public void testSend() throws Exception {
        FunctionalTestComponent ftc = this.lookupTestComponent();
        CountdownCallback callback = new CountdownCallback(1);
        ftc.setEventCallback((EventCallback)callback);
        this.send("Test Message", "in");
        AbstractJmsQueueFunctionalTestCase.assertTrue((boolean)callback.await(30000L));
        AbstractJmsQueueFunctionalTestCase.assertEquals((Object)"Test Message", (Object)ftc.getLastReceivedMessage());
        AbstractJmsQueueFunctionalTestCase.assertEquals((String)TEST_MESSAGE_RESPONSE, (String)this.receiveTextMessage("out"));
    }

    public void testSendWithReplyTo() throws Exception {
        FunctionalTestComponent ftc = this.lookupTestComponent();
        CountdownCallback callback = new CountdownCallback(1);
        ftc.setEventCallback((EventCallback)callback);
        this.send("Test Message", "in", false, this.getAcknowledgementMode(), "replyto");
        AbstractJmsQueueFunctionalTestCase.assertTrue((boolean)callback.await(30000L));
        AbstractJmsQueueFunctionalTestCase.assertEquals((Object)"Test Message", (Object)ftc.getLastReceivedMessage());
        AbstractJmsQueueFunctionalTestCase.assertEquals((String)TEST_MESSAGE_RESPONSE, (String)this.receiveTextMessage("out"));
    }

    public boolean useTopics() {
        return false;
    }

    protected FunctionalTestComponent lookupTestComponent() {
        try {
            if (this.useTopics()) {
                return this.lookupTestComponent("testModel", "topicComponent");
            }
            return this.lookupTestComponent("testModel", "queueComponent");
        }
        catch (UMOException e) {
            this.logger.error((Object)e);
            return null;
        }
    }
}

