/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms.vendors;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jms.Connection;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.xa.ConnectionFactoryWrapper;
import org.mule.providers.jms.xa.ConnectionInvocationHandler;
import org.mule.tck.FunctionalTestCase;

public class ActiveMqXaJmsConnectorTestCase
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "activemq-xa.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReflectiveXaCleanup() throws Exception {
        JmsConnector c = (JmsConnector)managementContext.getRegistry().lookupConnector("jmsConnector");
        ActiveMqXaJmsConnectorTestCase.assertNotNull((Object)c);
        Object cf = c.getConnectionFactory().getOrCreate();
        ActiveMqXaJmsConnectorTestCase.assertTrue((boolean)(cf instanceof ActiveMQXAConnectionFactory));
        ConnectionFactoryWrapper wrapper = new ConnectionFactoryWrapper(cf);
        Connection connection = wrapper.createConnection();
        ActiveMqXaJmsConnectorTestCase.assertNotNull((Object)connection);
        ActiveMqXaJmsConnectorTestCase.assertTrue((boolean)Proxy.isProxyClass(connection.getClass()));
        try {
            Method cleanupMethod;
            Class<?> clazz = connection.getClass();
            if (Proxy.isProxyClass(clazz)) {
                ConnectionInvocationHandler handler = (ConnectionInvocationHandler)Proxy.getInvocationHandler(connection);
                connection = (Connection)handler.getTargetObject();
                Class<?> realConnectionClass = connection.getClass();
                cleanupMethod = realConnectionClass.getMethod("cleanup", null);
            } else {
                cleanupMethod = clazz.getMethod("cleanup", null);
            }
            if (cleanupMethod != null) {
                cleanupMethod.invoke((Object)connection, null);
            }
        }
        finally {
            connection.close();
        }
    }
}

