/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import java.text.MessageFormat;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.XAConnectionFactory;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.commons.lang.UnhandledException;
import org.mule.config.ExceptionHelper;
import org.mule.config.ExceptionReader;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.internal.notifications.ConnectionNotificationListener;
import org.mule.impl.internal.notifications.NotificationException;
import org.mule.providers.AbstractConnector;
import org.mule.providers.ConnectException;
import org.mule.providers.FatalConnectException;
import org.mule.providers.ReplyToHandler;
import org.mule.providers.jms.DefaultJmsTopicResolver;
import org.mule.providers.jms.DefaultRedeliveryHandler;
import org.mule.providers.jms.Jms102bSupport;
import org.mule.providers.jms.Jms11Support;
import org.mule.providers.jms.JmsExceptionReader;
import org.mule.providers.jms.JmsMessageAdapter;
import org.mule.providers.jms.JmsReplyToHandler;
import org.mule.providers.jms.JmsSupport;
import org.mule.providers.jms.JmsTopicResolver;
import org.mule.providers.jms.i18n.JmsMessages;
import org.mule.providers.jms.xa.ConnectionFactoryWrapper;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.MessagingException;
import org.mule.umo.TransactionException;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.StartException;
import org.mule.umo.lifecycle.Startable;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.manager.UMOServerNotificationListener;
import org.mule.umo.provider.UMOConnectable;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.util.object.JndiObjectFactory;
import org.mule.util.object.ObjectFactory;
import org.mule.util.object.SimpleObjectFactory;

public class JmsConnector
extends AbstractConnector
implements ConnectionNotificationListener {
    private int acknowledgementMode = 1;
    private String clientId;
    private boolean durable;
    private boolean noLocal;
    private boolean persistentDelivery;
    private boolean honorQosHeaders;
    private int maxRedelivery = 0;
    private boolean cacheJmsSessions = false;
    private boolean recoverJmsConnections = true;
    private boolean eagerConsumer = true;
    private ObjectFactory connectionFactory;
    public String username = null;
    public String password = null;
    private Connection connection;
    private String specification = "1.0.2b";
    private JmsSupport jmsSupport;
    private JmsTopicResolver topicResolver;
    private ObjectFactory redeliveryHandler;
    private Context jndiContext;
    private boolean jndiDestinations = false;
    private boolean forceJndiDestinations = false;
    private String connectionFactoryJndiName;
    private String jndiInitialFactory;
    private String jndiProviderUrl;
    private Map jndiProviderProperties;

    public String getProtocol() {
        return "jms";
    }

    protected void doInitialise() throws InitialisationException {
        if (this.connectionFactory == null) {
            if (this.jndiInitialFactory != null) {
                this.connectionFactory = new JndiObjectFactory(this.connectionFactoryJndiName, this.jndiInitialFactory, this.jndiProviderUrl, this.jndiProviderProperties);
                this.connectionFactory.initialise();
                this.jndiContext = ((JndiObjectFactory)this.connectionFactory).getContext();
            } else if (this.getDefaultConnectionFactory() != null) {
                this.connectionFactory = this.getDefaultConnectionFactory();
                this.connectionFactory.initialise();
            } else {
                throw new InitialisationException(JmsMessages.noConnectionFactorySet(), (Initialisable)this);
            }
        }
        if (this.topicResolver == null) {
            this.topicResolver = new DefaultJmsTopicResolver(this);
        }
        if (this.redeliveryHandler == null) {
            this.redeliveryHandler = new SimpleObjectFactory(DefaultRedeliveryHandler.class);
            this.redeliveryHandler.initialise();
        }
        try {
            this.managementContext.registerListener((UMOServerNotificationListener)this, this.getName());
        }
        catch (NotificationException nex) {
            throw new InitialisationException((Throwable)nex, (Initialisable)this);
        }
    }

    protected ObjectFactory getDefaultConnectionFactory() {
        return null;
    }

    protected void doDispose() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                this.logger.error((Object)"Jms connector failed to dispose properly: ", (Throwable)e);
            }
            this.connection = null;
        }
        if (this.connectionFactory != null && this.connectionFactory instanceof Disposable) {
            this.connectionFactory.dispose();
        }
    }

    protected Connection createConnection() throws NamingException, JMSException, InitialisationException {
        ConnectionFactory cf;
        try {
            cf = (ConnectionFactory)this.connectionFactory.getOrCreate();
            if (cf instanceof XAConnectionFactory && this.managementContext.getTransactionManager() != null) {
                cf = new ConnectionFactoryWrapper(cf);
            }
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        if (cf == null) {
            throw new InitialisationException(JmsMessages.noConnectionFactorySet(), (Initialisable)this);
        }
        Connection connection = this.username != null ? this.jmsSupport.createConnection(cf, this.username, this.password) : this.jmsSupport.createConnection(cf);
        if (this.clientId != null) {
            connection.setClientID(this.getClientId());
        }
        if (this.recoverJmsConnections && this.connectionStrategy != null && connection != null) {
            connection.setExceptionListener(new ExceptionListener(){

                public void onException(JMSException jmsException) {
                    JmsConnector.this.logger.debug((Object)"About to recycle myself due to remote JMS connection shutdown.");
                    JmsConnector jmsConnector = JmsConnector.this;
                    try {
                        jmsConnector.stop();
                        jmsConnector.initialised.set(false);
                    }
                    catch (UMOException e) {
                        JmsConnector.this.logger.warn((Object)e.getMessage(), (Throwable)e);
                    }
                    try {
                        jmsConnector.initialise();
                        jmsConnector.start();
                    }
                    catch (FatalConnectException fcex) {
                        JmsConnector.this.logger.fatal((Object)"Failed to reconnect to JMS server. I'm giving up.");
                    }
                    catch (UMOException umoex) {
                        throw new UnhandledException("Failed to recover a connector.", (Throwable)umoex);
                    }
                }
            });
        }
        return connection;
    }

    protected void doConnect() throws ConnectException {
        try {
            if (this.jmsSupport == null) {
                this.jmsSupport = "1.0.2b".equals(this.specification) ? new Jms102bSupport(this) : new Jms11Support(this);
            }
        }
        catch (Exception e) {
            throw new ConnectException(CoreMessages.failedToCreate((String)"Jms Connector"), (Throwable)e, (UMOConnectable)this);
        }
        try {
            this.connection = this.createConnection();
            if (this.started.get()) {
                this.connection.start();
            }
        }
        catch (Exception e) {
            throw new ConnectException((Throwable)e, (UMOConnectable)this);
        }
    }

    protected void doDisconnect() throws ConnectException {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception e) {
            throw new ConnectException((Throwable)e, (UMOConnectable)this);
        }
        finally {
            this.connection = null;
        }
    }

    public UMOMessageAdapter getMessageAdapter(Object message) throws MessagingException {
        JmsMessageAdapter adapter = (JmsMessageAdapter)super.getMessageAdapter(message);
        adapter.setSpecification(this.getSpecification());
        return adapter;
    }

    protected Object getReceiverKey(UMOComponent component, UMOImmutableEndpoint endpoint) {
        return component.getName() + "~" + endpoint.getEndpointURI().getAddress();
    }

    public Session getSessionFromTransaction() {
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        if (tx != null && tx.hasResource((Object)this.connection)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieving jms session from current transaction " + tx));
            }
            Session session = (Session)tx.getResource((Object)this.connection);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using " + session + " bound to transaction " + tx));
            }
            return session;
        }
        return null;
    }

    public Session getSession(UMOImmutableEndpoint endpoint) throws JMSException {
        boolean topic = this.getTopicResolver().isTopic(endpoint);
        return this.getSession(endpoint.getTransactionConfig().isTransacted(), topic);
    }

    public Session getSession(boolean transacted, boolean topic) throws JMSException {
        if (!this.isConnected()) {
            throw new JMSException("Not connected");
        }
        Session session = this.getSessionFromTransaction();
        if (session != null) {
            return session;
        }
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)MessageFormat.format("Retrieving new jms session from connection: topic={0}, transacted={1}, ack mode={2}, nolocal={3}", topic, transacted, new Integer(this.acknowledgementMode), this.noLocal));
        }
        session = this.jmsSupport.createSession(this.connection, topic, transacted, this.acknowledgementMode, this.noLocal);
        if (tx != null) {
            this.logger.debug((Object)("Binding session " + session + " to current transaction " + tx));
            try {
                tx.bindResource((Object)this.connection, (Object)session);
            }
            catch (TransactionException e) {
                throw new RuntimeException("Could not bind session to current transaction", e);
            }
        }
        return session;
    }

    protected void doStart() throws UMOException {
        if (this.connection != null) {
            try {
                this.connection.start();
            }
            catch (JMSException e) {
                throw new StartException(CoreMessages.failedToStart((String)"Jms Connection"), (Throwable)e, (Startable)this);
            }
        }
    }

    protected void doStop() throws UMOException {
    }

    public ReplyToHandler getReplyToHandler() {
        return new JmsReplyToHandler(this, this.getDefaultResponseTransformers());
    }

    public void onNotification(UMOServerNotification notification) {
        if (notification.getAction() == 703 || notification.getAction() == 702) {
            this.disposeDispatchers();
        }
    }

    public boolean supportsProperty(String property) {
        return true;
    }

    public Message preProcessMessage(Message message, Session session) throws Exception {
        return message;
    }

    public void close(MessageProducer producer) throws JMSException {
        if (producer != null) {
            producer.close();
        }
    }

    public void closeQuietly(MessageProducer producer) {
        try {
            this.close(producer);
        }
        catch (JMSException e) {
            this.logger.error((Object)"Failed to close jms message producer", (Throwable)e);
        }
    }

    public void close(MessageConsumer consumer) throws JMSException {
        if (consumer != null) {
            consumer.close();
        }
    }

    public void closeQuietly(MessageConsumer consumer) {
        try {
            this.close(consumer);
        }
        catch (JMSException e) {
            this.logger.error((Object)"Failed to close jms message consumer", (Throwable)e);
        }
    }

    public void close(Session session) throws JMSException {
        if (session != null) {
            session.close();
        }
    }

    public void closeQuietly(Session session) {
        try {
            this.close(session);
        }
        catch (JMSException e) {
            this.logger.error((Object)"Failed to close jms session consumer", (Throwable)e);
        }
    }

    public void close(TemporaryQueue tempQueue) throws JMSException {
        if (tempQueue != null) {
            tempQueue.delete();
        }
    }

    public void closeQuietly(TemporaryQueue tempQueue) {
        block4: {
            try {
                this.close(tempQueue);
            }
            catch (JMSException e) {
                if (!this.logger.isErrorEnabled()) break block4;
                String queueName = "";
                try {
                    queueName = tempQueue.getQueueName();
                }
                catch (JMSException innerEx) {
                    // empty catch block
                }
                this.logger.info((Object)MessageFormat.format("Faled to delete a temporary queue '{0}' Reason: {1}", queueName, e.getMessage()));
            }
        }
    }

    public void close(TemporaryTopic tempTopic) throws JMSException {
        if (tempTopic != null) {
            tempTopic.delete();
        }
    }

    public void closeQuietly(TemporaryTopic tempTopic) {
        block4: {
            try {
                this.close(tempTopic);
            }
            catch (JMSException e) {
                if (!this.logger.isErrorEnabled()) break block4;
                String topicName = "";
                try {
                    topicName = tempTopic.getTopicName();
                }
                catch (JMSException innerEx) {
                    // empty catch block
                }
                this.logger.error((Object)("Faled to delete a temporary topic " + topicName), (Throwable)e);
            }
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected void setConnection(Connection connection) {
        this.connection = connection;
    }

    public int getAcknowledgementMode() {
        return this.acknowledgementMode;
    }

    public void setAcknowledgementMode(int acknowledgementMode) {
        this.acknowledgementMode = acknowledgementMode;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public boolean isPersistentDelivery() {
        return this.persistentDelivery;
    }

    public void setPersistentDelivery(boolean persistentDelivery) {
        this.persistentDelivery = persistentDelivery;
    }

    public JmsSupport getJmsSupport() {
        return this.jmsSupport;
    }

    public void setJmsSupport(JmsSupport jmsSupport) {
        this.jmsSupport = jmsSupport;
    }

    public String getSpecification() {
        return this.specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    public void setRecoverJmsConnections(boolean recover) {
        this.recoverJmsConnections = recover;
    }

    public boolean isRecoverJmsConnections() {
        return this.recoverJmsConnections;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public int getMaxRedelivery() {
        return this.maxRedelivery;
    }

    public void setMaxRedelivery(int maxRedelivery) {
        this.maxRedelivery = maxRedelivery;
    }

    public boolean isRemoteSyncEnabled() {
        return true;
    }

    public JmsTopicResolver getTopicResolver() {
        return this.topicResolver;
    }

    public void setTopicResolver(JmsTopicResolver topicResolver) {
        this.topicResolver = topicResolver;
    }

    public boolean isEagerConsumer() {
        return this.eagerConsumer;
    }

    public void setEagerConsumer(boolean eagerConsumer) {
        this.eagerConsumer = eagerConsumer;
    }

    public boolean isCacheJmsSessions() {
        return this.cacheJmsSessions;
    }

    public void setCacheJmsSessions(boolean cacheJmsSessions) {
        this.cacheJmsSessions = cacheJmsSessions;
    }

    public ObjectFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ObjectFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public ObjectFactory getRedeliveryHandler() {
        return this.redeliveryHandler;
    }

    public void setRedeliveryHandler(ObjectFactory redeliveryHandler) {
        this.redeliveryHandler = redeliveryHandler;
    }

    public boolean isJndiDestinations() {
        return this.jndiDestinations;
    }

    public void setJndiDestinations(boolean jndiDestinations) {
        this.jndiDestinations = jndiDestinations;
    }

    public Context getJndiContext() {
        return this.jndiContext;
    }

    public void setJndiContext(Context jndiContext) {
        this.jndiContext = jndiContext;
    }

    public boolean isForceJndiDestinations() {
        return this.forceJndiDestinations;
    }

    public void setForceJndiDestinations(boolean forceJndiDestinations) {
        this.forceJndiDestinations = forceJndiDestinations;
    }

    public void setHonorQosHeaders(boolean honorQosHeaders) {
        this.honorQosHeaders = honorQosHeaders;
    }

    public boolean isHonorQosHeaders() {
        return this.honorQosHeaders;
    }

    public String getConnectionFactoryJndiName() {
        return this.connectionFactoryJndiName;
    }

    public void setConnectionFactoryJndiName(String connectionFactoryJndiName) {
        this.connectionFactoryJndiName = connectionFactoryJndiName;
    }

    public String getJndiInitialFactory() {
        return this.jndiInitialFactory;
    }

    public void setJndiInitialFactory(String jndiInitialFactory) {
        this.jndiInitialFactory = jndiInitialFactory;
    }

    public String getJndiProviderUrl() {
        return this.jndiProviderUrl;
    }

    public void setJndiProviderUrl(String jndiProviderUrl) {
        this.jndiProviderUrl = jndiProviderUrl;
    }

    public Map getJndiProviderProperties() {
        return this.jndiProviderProperties;
    }

    public void setJndiProviderProperties(Map jndiProviderProperties) {
        this.jndiProviderProperties = jndiProviderProperties;
    }

    static {
        ExceptionHelper.registerExceptionReader((ExceptionReader)new JmsExceptionReader());
    }
}

