/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.mule.providers.jms.JmsConnector;
import org.mule.util.ArrayUtils;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;

public class JmsMessageUtils {
    public static final char REPLACEMENT_CHAR = '_';

    public static String encodeHeader(String name) {
        int i;
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("Header name to encode must not be null or empty");
        }
        int length = name.length();
        for (i = 0; i < length && Character.isJavaIdentifierPart(name.charAt(i)); ++i) {
        }
        if (i == length) {
            return name;
        }
        StringBuffer sb = new StringBuffer(name);
        for (int j = i; j < length; ++j) {
            if (Character.isJavaIdentifierPart(sb.charAt(j))) continue;
            sb.setCharAt(j, '_');
        }
        return sb.toString();
    }

    public static Message toMessage(Object object, Session session) throws JMSException {
        if (object instanceof Message) {
            return (Message)object;
        }
        if (object instanceof String) {
            return session.createTextMessage((String)object);
        }
        if (object instanceof Map) {
            MapMessage mMsg = session.createMapMessage();
            Map src = (Map)object;
            Iterator i = src.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                mMsg.setObject(entry.getKey().toString(), entry.getValue());
            }
            return mMsg;
        }
        if (object instanceof InputStream) {
            StreamMessage sMsg = session.createStreamMessage();
            InputStream temp = (InputStream)object;
            byte[] buffer = new byte[4096];
            try {
                int len;
                while ((len = temp.read(buffer)) != -1) {
                    sMsg.writeBytes(buffer, 0, len);
                }
            }
            catch (IOException e) {
                throw new JMSException("Failed to read input stream to create a stream message: " + e);
            }
            return sMsg;
        }
        if (object instanceof byte[]) {
            BytesMessage bMsg = session.createBytesMessage();
            bMsg.writeBytes((byte[])object);
            return bMsg;
        }
        if (object instanceof Serializable) {
            ObjectMessage oMsg = session.createObjectMessage();
            oMsg.setObject((Serializable)object);
            return oMsg;
        }
        throw new JMSException("Source was not of a supported type, data must be Serializable, String, byte[], Map or InputStream, but was " + ClassUtils.getShortClassName((Object)object, (String)"<null>"));
    }

    public static Object toObject(Message source, String jmsSpec) throws JMSException, IOException {
        if (source instanceof ObjectMessage) {
            return ((ObjectMessage)source).getObject();
        }
        if (source instanceof MapMessage) {
            Hashtable<String, Object> map = new Hashtable<String, Object>();
            MapMessage m = (MapMessage)source;
            Enumeration e = m.getMapNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Object obj = m.getObject(name);
                map.put(name, obj);
            }
            return map;
        }
        if (source instanceof TextMessage) {
            return ((TextMessage)source).getText();
        }
        if (source instanceof BytesMessage) {
            return JmsMessageUtils.toByteArray(source, jmsSpec);
        }
        if (source instanceof StreamMessage) {
            try {
                Object obj;
                StreamMessage sMsg = (StreamMessage)source;
                Vector<Object> result = new Vector<Object>();
                while ((obj = sMsg.readObject()) != null) {
                    result.addElement(obj);
                }
                return result;
            }
            catch (MessageEOFException eof) {
            }
            catch (Exception e) {
                throw new JMSException("Failed to extract information from JMS Stream Message: " + e);
            }
        }
        return source;
    }

    public static byte[] toByteArray(Message message, String jmsSpec) throws JMSException, IOException {
        if (message instanceof BytesMessage) {
            int len;
            BytesMessage bMsg = (BytesMessage)message;
            bMsg.reset();
            if ("1.1".equals(jmsSpec)) {
                long bmBodyLength = bMsg.getBodyLength();
                if (bmBodyLength > Integer.MAX_VALUE) {
                    throw new JMSException("Size of BytesMessage exceeds Integer.MAX_VALUE; please consider using JMS StreamMessage instead");
                }
                if (bmBodyLength > 0L) {
                    byte[] bytes = new byte[(int)bmBodyLength];
                    bMsg.readBytes(bytes);
                    return bytes;
                }
                return ArrayUtils.EMPTY_BYTE_ARRAY;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            byte[] buffer = new byte[4096];
            while ((len = bMsg.readBytes(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            if (baos.size() > 0) {
                return baos.toByteArray();
            }
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        if (message instanceof StreamMessage) {
            int len;
            StreamMessage sMsg = (StreamMessage)message;
            sMsg.reset();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            byte[] buffer = new byte[4096];
            while ((len = sMsg.readBytes(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            return baos.toByteArray();
        }
        if (message instanceof ObjectMessage) {
            ObjectMessage oMsg = (ObjectMessage)message;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream((OutputStream)baos);
            os.writeObject(oMsg.getObject());
            os.flush();
            os.close();
            return baos.toByteArray();
        }
        if (message instanceof TextMessage) {
            TextMessage tMsg = (TextMessage)message;
            String tMsgText = tMsg.getText();
            if (null == tMsgText) {
                return ArrayUtils.EMPTY_BYTE_ARRAY;
            }
            return tMsgText.getBytes();
        }
        throw new JMSException("Cannot get bytes from Map Message");
    }

    public static String getNameForDestination(Destination dest) throws JMSException {
        if (dest instanceof Queue) {
            return ((Queue)dest).getQueueName();
        }
        if (dest instanceof Topic) {
            return ((Topic)dest).getTopicName();
        }
        return null;
    }

    public static Message copyJMSProperties(Message from, Message to, JmsConnector connector) throws JMSException {
        if (connector.supportsProperty("JMSCorrelationID")) {
            to.setJMSCorrelationID(from.getJMSCorrelationID());
        }
        if (connector.supportsProperty("JMSDeliveryMode")) {
            to.setJMSDeliveryMode(from.getJMSDeliveryMode());
        }
        if (connector.supportsProperty("JMSDestination")) {
            to.setJMSDestination(from.getJMSDestination());
        }
        if (connector.supportsProperty("JMSExpiration")) {
            to.setJMSExpiration(from.getJMSExpiration());
        }
        if (connector.supportsProperty("JMSMessageID")) {
            to.setJMSMessageID(from.getJMSMessageID());
        }
        if (connector.supportsProperty("JMSPriority")) {
            to.setJMSPriority(from.getJMSPriority());
        }
        if (connector.supportsProperty("JMSRedelivered")) {
            to.setJMSRedelivered(from.getJMSRedelivered());
        }
        if (connector.supportsProperty("JMSReplyTo")) {
            to.setJMSReplyTo(from.getJMSReplyTo());
        }
        if (connector.supportsProperty("JMSTimestamp")) {
            to.setJMSTimestamp(from.getJMSTimestamp());
        }
        if (connector.supportsProperty("JMSType")) {
            to.setJMSType(from.getJMSType());
        }
        return to;
    }
}

