/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms.activemq;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import javax.jms.Connection;
import org.mule.providers.ConnectException;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.xa.ConnectionInvocationHandler;
import org.mule.umo.provider.UMOConnectable;
import org.mule.util.object.ObjectFactory;
import org.mule.util.object.SimpleObjectFactory;

public class ActiveMqJmsConnector
extends JmsConnector {
    public static final String ACTIVEMQ_CONNECTION_FACTORY = "org.apache.activemq.ActiveMQConnectionFactory";
    public static final String BROKER_URL = "vm://localhost?broker.persistent=false&broker.useJmx=false";

    public ActiveMqJmsConnector() {
        this.setSpecification("1.1");
        this.setEagerConsumer(false);
    }

    protected ObjectFactory getDefaultConnectionFactory() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("brokerURL", BROKER_URL);
        return new SimpleObjectFactory(ACTIVEMQ_CONNECTION_FACTORY, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDisconnect() throws ConnectException {
        try {
            Method cleanupMethod;
            Connection connection = this.getConnection();
            if (connection == null) {
                return;
            }
            Class<?> clazz = connection.getClass();
            if (Proxy.isProxyClass(clazz)) {
                ConnectionInvocationHandler handler = (ConnectionInvocationHandler)Proxy.getInvocationHandler(connection);
                connection = (Connection)handler.getTargetObject();
                Class<?> realConnectionClass = connection.getClass();
                cleanupMethod = realConnectionClass.getMethod("cleanup", null);
            } else {
                cleanupMethod = clazz.getMethod("cleanup", null);
            }
            try {
                if (cleanupMethod != null) {
                    cleanupMethod.invoke((Object)connection, null);
                }
            }
            finally {
                connection.close();
            }
        }
        catch (Exception e) {
            throw new ConnectException((Throwable)e, (UMOConnectable)this);
        }
        finally {
            this.setConnection(null);
        }
    }
}

