/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms.xa;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicSession;
import javax.transaction.xa.XAResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.providers.jms.xa.ConsumerProducerInvocationHandler;
import org.mule.providers.jms.xa.XAResourceWrapper;
import org.mule.transaction.TransactionCoordination;
import org.mule.transaction.XaTransaction;
import org.mule.umo.UMOTransaction;

public class SessionInvocationHandler
implements InvocationHandler {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    private XASession xaSession;
    private XAResource xaResource;
    private volatile boolean enlisted = false;
    private final Reference underlyingObject;

    public SessionInvocationHandler(XASession xaSession) throws JMSException {
        this.xaSession = xaSession;
        this.underlyingObject = new WeakReference<Session>(xaSession.getSession());
        this.xaResource = new XAResourceWrapper(xaSession.getXAResource(), this);
    }

    public SessionInvocationHandler(XAQueueSession xaSession) throws JMSException {
        this.xaSession = xaSession;
        this.underlyingObject = new WeakReference<QueueSession>(xaSession.getQueueSession());
        this.xaResource = new XAResourceWrapper(xaSession.getXAResource(), this);
    }

    public SessionInvocationHandler(XATopicSession xaSession) throws JMSException {
        this.xaSession = xaSession;
        this.underlyingObject = new WeakReference<TopicSession>(xaSession.getTopicSession());
        this.xaResource = new XAResourceWrapper(xaSession.getXAResource(), this);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking " + method));
        }
        if (this.underlyingObject.get() == null) {
            throw new IllegalStateException("Underlying xaSession is null, XASession " + this.xaSession);
        }
        Object result = method.invoke(this.underlyingObject.get(), args);
        if (result instanceof TopicSubscriber) {
            result = Proxy.newProxyInstance(Session.class.getClassLoader(), new Class[]{TopicSubscriber.class}, (InvocationHandler)new ConsumerProducerInvocationHandler(this, result));
        } else if (result instanceof QueueReceiver) {
            result = Proxy.newProxyInstance(Session.class.getClassLoader(), new Class[]{QueueReceiver.class}, (InvocationHandler)new ConsumerProducerInvocationHandler(this, result));
        } else if (result instanceof MessageConsumer) {
            result = Proxy.newProxyInstance(Session.class.getClassLoader(), new Class[]{MessageConsumer.class}, (InvocationHandler)new ConsumerProducerInvocationHandler(this, result));
        } else if (result instanceof TopicPublisher) {
            result = Proxy.newProxyInstance(Session.class.getClassLoader(), new Class[]{TopicPublisher.class}, (InvocationHandler)new ConsumerProducerInvocationHandler(this, result));
        } else if (result instanceof QueueSender) {
            result = Proxy.newProxyInstance(Session.class.getClassLoader(), new Class[]{QueueSender.class}, (InvocationHandler)new ConsumerProducerInvocationHandler(this, result));
        } else if (result instanceof MessageProducer) {
            result = Proxy.newProxyInstance(Session.class.getClassLoader(), new Class[]{MessageProducer.class}, (InvocationHandler)new ConsumerProducerInvocationHandler(this, result));
        }
        return result;
    }

    protected void enlist() throws Exception {
        UMOTransaction transaction;
        if (this.isEnlisted()) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Enlistment request: " + this));
        }
        if ((transaction = TransactionCoordination.getInstance().getTransaction()) == null) {
            this.logger.warn((Object)"Mule transaction is null, but enlist method is called");
        }
        if (transaction != null && !(transaction instanceof XaTransaction)) {
            throw new IllegalStateException(CoreMessages.notMuleXaTransaction((Object)transaction).toString());
        }
        if (transaction != null && !this.isEnlisted()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Enlisting resource " + this.xaResource + " in xa transaction " + transaction));
            }
            this.enlisted = ((XaTransaction)transaction).enlistResource(this.xaResource);
        }
    }

    public boolean isEnlisted() {
        return this.enlisted;
    }

    public void setEnlisted(boolean enlisted) {
        this.enlisted = enlisted;
    }

    public XASession getTargetObject() {
        return this.xaSession;
    }

    public XAResource getXAResource() {
        return this.xaResource;
    }
}

