/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms.config;

import org.mule.providers.jms.DefaultRedeliveryHandler;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.test.TestConnectionFactory;
import org.mule.providers.jms.test.TestRedeliveryHandler;
import org.mule.tck.FunctionalTestCase;
import org.mule.tck.testmodels.mule.TestTransactionFactory;

public class JmsNamespaceHandlerTestCase
extends FunctionalTestCase {
    public JmsNamespaceHandlerTestCase() {
        this.setStartContext(false);
    }

    protected String getConfigResources() {
        return "jms-namespace-config.xml";
    }

    public void testDefaultConfig() throws Exception {
        JmsConnector c = (JmsConnector)managementContext.getRegistry().lookupConnector("jmsConnectorDefaults");
        JmsNamespaceHandlerTestCase.assertNotNull((Object)c);
        JmsNamespaceHandlerTestCase.assertNotNull((Object)c.getConnectionFactory());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)(c.getConnectionFactory().getOrCreate() instanceof TestConnectionFactory));
        JmsNamespaceHandlerTestCase.assertEquals((int)1, (int)c.getAcknowledgementMode());
        JmsNamespaceHandlerTestCase.assertNull((Object)c.getUsername());
        JmsNamespaceHandlerTestCase.assertNull((Object)c.getPassword());
        JmsNamespaceHandlerTestCase.assertNotNull((Object)c.getRedeliveryHandler());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)(c.getRedeliveryHandler().getOrCreate() instanceof DefaultRedeliveryHandler));
        JmsNamespaceHandlerTestCase.assertNull((Object)c.getClientId());
        JmsNamespaceHandlerTestCase.assertFalse((boolean)c.isDurable());
        JmsNamespaceHandlerTestCase.assertFalse((boolean)c.isNoLocal());
        JmsNamespaceHandlerTestCase.assertFalse((boolean)c.isPersistentDelivery());
        JmsNamespaceHandlerTestCase.assertEquals((int)0, (int)c.getMaxRedelivery());
        JmsNamespaceHandlerTestCase.assertFalse((boolean)c.isCacheJmsSessions());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)c.isRecoverJmsConnections());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)c.isEagerConsumer());
        JmsNamespaceHandlerTestCase.assertFalse((boolean)c.isJndiDestinations());
        JmsNamespaceHandlerTestCase.assertFalse((boolean)c.isForceJndiDestinations());
    }

    public void testConnectorConfig() throws Exception {
        JmsConnector c = (JmsConnector)managementContext.getRegistry().lookupConnector("jmsConnector1");
        JmsNamespaceHandlerTestCase.assertNotNull((Object)c);
        JmsNamespaceHandlerTestCase.assertNotNull((Object)c.getConnectionFactory());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)(c.getConnectionFactory().getOrCreate() instanceof TestConnectionFactory));
        JmsNamespaceHandlerTestCase.assertEquals((int)3, (int)c.getAcknowledgementMode());
        JmsNamespaceHandlerTestCase.assertEquals((String)"myuser", (String)c.getUsername());
        JmsNamespaceHandlerTestCase.assertEquals((String)"mypass", (String)c.getPassword());
        JmsNamespaceHandlerTestCase.assertNotNull((Object)c.getRedeliveryHandler());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)(c.getRedeliveryHandler().getOrCreate() instanceof TestRedeliveryHandler));
        JmsNamespaceHandlerTestCase.assertEquals((String)"myClient", (String)c.getClientId());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)c.isDurable());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)c.isNoLocal());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)c.isPersistentDelivery());
        JmsNamespaceHandlerTestCase.assertEquals((int)5, (int)c.getMaxRedelivery());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)c.isCacheJmsSessions());
        JmsNamespaceHandlerTestCase.assertFalse((boolean)c.isRecoverJmsConnections());
        JmsNamespaceHandlerTestCase.assertFalse((boolean)c.isEagerConsumer());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)c.isJndiDestinations());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)c.isForceJndiDestinations());
        JmsNamespaceHandlerTestCase.assertEquals((String)"1.1", (String)c.getSpecification());
        JmsNamespaceHandlerTestCase.assertEquals((int)c.getNumberOfConcurrentTransactedReceivers(), (int)7);
    }

    public void testCustomConnectorConfig() throws Exception {
        JmsConnector c = (JmsConnector)managementContext.getRegistry().lookupConnector("jmsConnector2");
        JmsNamespaceHandlerTestCase.assertNotNull((Object)c);
        JmsNamespaceHandlerTestCase.assertEquals((String)"1.1", (String)c.getSpecification());
    }

    public void testTestConnectorConfig() throws Exception {
        JmsConnector c = (JmsConnector)managementContext.getRegistry().lookupConnector("jmsConnector3");
        JmsNamespaceHandlerTestCase.assertNotNull((Object)c);
        JmsNamespaceHandlerTestCase.assertNotNull((Object)c.getConnectionFactory());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)(c.getConnectionFactory().getOrCreate() instanceof TestConnectionFactory));
        JmsNamespaceHandlerTestCase.assertEquals((int)3, (int)c.getAcknowledgementMode());
        JmsNamespaceHandlerTestCase.assertNotNull((Object)c.getRedeliveryHandler());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)(c.getRedeliveryHandler().getOrCreate() instanceof TestRedeliveryHandler));
        JmsNamespaceHandlerTestCase.assertEquals((String)"myClient", (String)c.getClientId());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)c.isDurable());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)c.isNoLocal());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)c.isPersistentDelivery());
        JmsNamespaceHandlerTestCase.assertEquals((int)5, (int)c.getMaxRedelivery());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)c.isCacheJmsSessions());
        JmsNamespaceHandlerTestCase.assertFalse((boolean)c.isRecoverJmsConnections());
        JmsNamespaceHandlerTestCase.assertFalse((boolean)c.isEagerConsumer());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)c.isJndiDestinations());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)c.isForceJndiDestinations());
        JmsNamespaceHandlerTestCase.assertEquals((String)"1.1", (String)c.getSpecification());
    }

    public void testTransactionFactory() {
        TestTransactionFactory factory = (TestTransactionFactory)managementContext.getRegistry().lookupObject("txFactory");
        JmsNamespaceHandlerTestCase.assertNotNull((Object)factory);
        JmsNamespaceHandlerTestCase.assertEquals((String)"foo", (String)factory.getValue());
    }
}

