/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms.integration;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import junit.framework.Assert;
import org.mule.providers.jms.integration.AbstractJmsFunctionalTestCase;
import org.mule.providers.jms.integration.JmsDurableTopicTestCase;

public class JmsDurableTopicSingleTxTestCase
extends JmsDurableTopicTestCase {
    public static final String TOPIC_QUEUE_NAME = "durable.broadcast";
    AbstractJmsFunctionalTestCase.Scenario scenarioCommit = new AbstractJmsFunctionalTestCase.AbstractScenario(){

        public String getOutputQueue() {
            return JmsDurableTopicSingleTxTestCase.TOPIC_QUEUE_NAME;
        }

        public void send(Session session, MessageProducer producer) throws JMSException {
            producer.send((Message)session.createTextMessage("INPUT MESSAGE"));
            session.commit();
        }

        public Message receive(Session session, MessageConsumer consumer) throws JMSException {
            Message message = consumer.receive(5000L);
            Assert.assertNotNull((Object)message);
            session.commit();
            return message;
        }

        public boolean isTransacted() {
            return true;
        }
    };
    AbstractJmsFunctionalTestCase.Scenario scenarioRollback = new AbstractJmsFunctionalTestCase.AbstractScenario(){

        public String getOutputQueue() {
            return JmsDurableTopicSingleTxTestCase.TOPIC_QUEUE_NAME;
        }

        public void send(Session session, MessageProducer producer) throws JMSException {
            producer.send((Message)session.createTextMessage("INPUT MESSAGE"));
            session.rollback();
        }

        public Message receive(Session session, MessageConsumer consumer) throws JMSException {
            Message message = consumer.receive(5000L);
            Assert.assertNotNull((Object)message);
            session.rollback();
            return message;
        }

        public boolean isTransacted() {
            return true;
        }
    };
    AbstractJmsFunctionalTestCase.Scenario scenarioNotReceive = new AbstractJmsFunctionalTestCase.AbstractScenario(){

        public String getOutputQueue() {
            return JmsDurableTopicSingleTxTestCase.TOPIC_QUEUE_NAME;
        }

        public Message receive(Session session, MessageConsumer consumer) throws JMSException {
            Message message = consumer.receive(1000L);
            Assert.assertNull((Object)message);
            return message;
        }

        public boolean isTransacted() {
            return true;
        }
    };

    protected String getConfigResources() {
        return "providers/activemq/jms-durable-topic-single-tx.xml";
    }

    public void testProviderDurableSubscriber() throws Exception {
        this.setClientId("Client1");
        this.receive(this.scenarioNotReceive);
        this.setClientId("Client2");
        this.receive(this.scenarioNotReceive);
        this.setClientId("Sender");
        this.send(this.scenarioCommit);
        this.setClientId("Client1");
        this.receive(this.scenarioCommit);
        this.receive(this.scenarioNotReceive);
        this.setClientId("Client2");
        this.receive(this.scenarioRollback);
        this.receive(this.scenarioCommit);
        this.receive(this.scenarioNotReceive);
    }
}

