/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms.integration;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import junit.framework.Assert;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQTopic;
import org.mule.providers.jms.integration.AbstractJmsFunctionalTestCase;

public class JmsMuleSideDurableTopicTestCase
extends AbstractJmsFunctionalTestCase {
    public static final String TOPIC_QUEUE_NAME = "durable.broadcast";
    public static final String CONNECTOR1_NAME = "jmsConnectorC1";
    AbstractJmsFunctionalTestCase.Scenario scenarioNoTx = new AbstractJmsFunctionalTestCase.AbstractScenario(){

        public String getInputQueue() {
            return JmsMuleSideDurableTopicTestCase.TOPIC_QUEUE_NAME;
        }

        public void send(Session session, MessageProducer producer) throws JMSException {
            producer.send((Message)session.createTextMessage("INPUT MESSAGE"));
        }

        public Message receive(Session session, MessageConsumer consumer) throws JMSException {
            Message message = consumer.receive(5000L);
            Assert.assertNotNull((Object)message);
            Assert.assertTrue((boolean)(class$javax$jms$TextMessage == null ? (class$javax$jms$TextMessage = JmsMuleSideDurableTopicTestCase.class$("javax.jms.TextMessage")) : class$javax$jms$TextMessage).isAssignableFrom(message.getClass()));
            Assert.assertEquals((String)((TextMessage)message).getText(), (String)"OUTPUT MESSAGE");
            return message;
        }
    };
    static /* synthetic */ Class class$javax$jms$TextMessage;

    protected String getConfigResources() {
        return "providers/activemq/jms-muleside-durable-topic.xml";
    }

    public void testMuleDurableSubscriber() throws Exception {
        this.send(this.scenarioNoTx);
        this.receive(this.scenarioNoTx);
        this.receive(this.scenarioNoTx);
        managementContext.getRegistry().lookupConnector(CONNECTOR1_NAME).stop();
        JmsMuleSideDurableTopicTestCase.assertEquals((boolean)managementContext.getRegistry().lookupConnector(CONNECTOR1_NAME).isStarted(), (boolean)false);
        this.logger.info((Object)"jmsConnectorC1 is stopped");
        this.send(this.scenarioNoTx);
        managementContext.getRegistry().lookupConnector(CONNECTOR1_NAME).start();
        this.logger.info((Object)"jmsConnectorC1 is started");
        this.receive(this.scenarioNoTx);
        this.receive(this.scenarioNoTx);
    }

    public void send(AbstractJmsFunctionalTestCase.Scenario scenario) throws Exception {
        TopicConnection connection = null;
        try {
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(scenario.getBrokerUrl());
            connection = factory.createTopicConnection();
            connection.start();
            TopicSession session = null;
            try {
                session = connection.createTopicSession(scenario.isTransacted(), scenario.getAcknowledge());
                ActiveMQTopic destination = new ActiveMQTopic(scenario.getInputQueue());
                TopicPublisher publisher = null;
                try {
                    publisher = session.createPublisher((Topic)destination);
                    publisher.setDeliveryMode(2);
                    scenario.send((Session)session, (MessageProducer)publisher);
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    if (publisher != null) {
                        publisher.close();
                    }
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

