/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms.issues;

import javax.jms.ConnectionFactory;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.impl.MuleMessage;
import org.mule.impl.RequestContext;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.functional.AbstractJmsFunctionalTestCase;
import org.mule.providers.jms.transformers.ObjectToJMSMessage;
import org.mule.transformers.AbstractMessageAwareTransformer;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.transformer.TransformerException;

public class MessageAwareTransformersMule2685TestCase
extends AbstractJmsFunctionalTestCase {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Session session = null;
    static /* synthetic */ Class class$org$mule$umo$UMOMessage;

    protected String getConfigResources() {
        return "activemq-config.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        JmsConnector connector = (JmsConnector)managementContext.getRegistry().lookupConnector("jmsConnector");
        ConnectionFactory cf = (ConnectionFactory)connector.getConnectionFactory().getOrCreate();
        this.session = cf.createConnection().createSession(false, 1);
    }

    protected void doTearDown() throws Exception {
        RequestContext.setEvent(null);
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    public void testMessageAwareTransformerChainedWithObjectToJMSMessage() throws Exception {
        RequestContext.setEvent((UMOEvent)MessageAwareTransformersMule2685TestCase.getTestEvent((Object)"test"));
        MuleMessage message = new MuleMessage((Object)"This is a test TextMessage");
        SetTestRecipientsTransformer trans = new SetTestRecipientsTransformer();
        UMOMessage result1 = (UMOMessage)trans.transform(message);
        MessageAwareTransformersMule2685TestCase.assertEquals((Object)"vm://recipient1, vm://recipient1, vm://recipient3", (Object)result1.getProperty("recipients"));
        SessionEnabledObjectToJMSMessage trans2 = new SessionEnabledObjectToJMSMessage(this.session);
        Message result2 = (Message)trans2.transform(result1);
        MessageAwareTransformersMule2685TestCase.assertTrue((String)"Transformed object should be a TextMessage", (boolean)(result2 instanceof TextMessage));
        MessageAwareTransformersMule2685TestCase.assertEquals((String)"This is a test TextMessage", (String)((TextMessage)result2).getText());
        MessageAwareTransformersMule2685TestCase.assertEquals((String)"vm://recipient1, vm://recipient1, vm://recipient3", (String)result2.getStringProperty("recipients"));
    }

    private class SetTestRecipientsTransformer
    extends AbstractMessageAwareTransformer {
        public SetTestRecipientsTransformer() {
            this.registerSourceType(class$org$mule$umo$UMOMessage == null ? (class$org$mule$umo$UMOMessage = MessageAwareTransformersMule2685TestCase.class$("org.mule.umo.UMOMessage")) : class$org$mule$umo$UMOMessage);
        }

        public Object transform(UMOMessage message, String outputEncoding) throws TransformerException {
            String recipients = "vm://recipient1, vm://recipient1, vm://recipient3";
            this.logger.debug((Object)("Setting recipients to '" + recipients + "'"));
            message.setProperty("recipients", (Object)recipients);
            return message;
        }
    }

    public static class SessionEnabledObjectToJMSMessage
    extends ObjectToJMSMessage {
        private final Session transformerSession;

        public SessionEnabledObjectToJMSMessage(Session session) {
            this.transformerSession = session;
        }

        protected Session getSession() {
            return this.transformerSession;
        }
    }
}

