/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.ClassUtils;
import org.mule.util.FileUtils;
import org.mule.util.IOUtils;

public class JmsTestUtils {
    private static final Log logger = LogFactory.getLog((Class)JmsTestUtils.class);
    public static final String UBERMQ_JMS_PROPERTIES = "ubermq-jndi-connection.properties";
    public static final String OPEN_JMS_PROPERTIES = "openjms-jndi-connection.properties";
    public static final String JORAM_JMS_PROPERTIES = "joram-jndi-connection.properties";
    public static final String SPIRIT_WAVE_JMS_PROPERTIES = "spiritwave-jndi-connection.properties";
    public static final String ACTIVE_MQ_JMS_PROPERTIES = "activemq-jndi-connection.properties";
    public static final String JMS_PROPERTIES = "mule-jms-provider.properties";
    public static final String JMS_PROPERTIES_PROPERTY = "org.mule.test.jms.properties";
    public static final String DEFAULT_JNDI_CONECTION_NAME_PROPERTY = "connectionFactoryJNDIName";
    public static final String JNDI_QUEUE_CONECTION_NAME_PROPERTY = "QueueConnectionFactoryJNDIName";
    public static final String JNDI_TOPIC_CONECTION_NAME_PROPERTY = "TopicConnectionFactoryJNDIName";
    public static final String JNDI_XAQUEUE_CONECTION_NAME_PROPERTY = "XAQueueConnectionFactoryJNDIName";
    public static final String JNDI_XATOPIC_CONECTION_NAME_PROPERTY = "XATopicConnectionFactoryJNDIName";

    public static Properties getJmsProperties() throws IOException {
        InputStream is = IOUtils.getResourceAsStream((String)JMS_PROPERTIES, (Class)JmsTestUtils.class);
        String jmsProps = OPEN_JMS_PROPERTIES;
        if (is != null) {
            Properties p = new Properties();
            p.load(is);
            jmsProps = p.getProperty("jms.provider.properties", OPEN_JMS_PROPERTIES);
            is.close();
        }
        return JmsTestUtils.getJmsProperties(jmsProps);
    }

    public static Properties getJmsProperties(String propertyFile) throws IOException {
        InputStream is = IOUtils.getResourceAsStream((String)propertyFile, (Class)JmsTestUtils.class);
        Properties p = new Properties();
        p.load(is);
        is.close();
        JmsTestUtils.fixProviderUrl(p);
        return p;
    }

    public static void fixProviderUrl(Properties props) throws IOException {
        String providerUrl = props.getProperty("java.naming.provider.url");
        if (providerUrl != null && !providerUrl.startsWith("file:") && providerUrl.indexOf(58) < 0) {
            providerUrl = "file:" + File.separator + FileUtils.getResourcePath((String)providerUrl, (Class)JmsTestUtils.class);
            logger.debug((Object)("Setting provider url to: " + providerUrl));
            props.setProperty("java.naming.provider.url", providerUrl);
        }
    }

    public static QueueConnection getQueueConnection() throws IOException, NamingException, JMSException {
        return JmsTestUtils.getQueueConnection(JmsTestUtils.getJmsProperties());
    }

    public static XAQueueConnection getXAQueueConnection() throws IOException, NamingException, JMSException {
        return JmsTestUtils.getXAQueueConnection(JmsTestUtils.getJmsProperties());
    }

    public static XAQueueConnection getXAQueueConnection(Properties props) throws IOException, NamingException, JMSException {
        XAQueueConnection cnn;
        String cnnFactoryName = props.getProperty(JNDI_XAQUEUE_CONECTION_NAME_PROPERTY);
        if (cnnFactoryName == null) {
            throw new IOException("You must set the property XAQueueConnectionFactoryJNDINamein the JNDI property file");
        }
        InitialContext ctx = new InitialContext(props);
        XAQueueConnectionFactory qcf = (XAQueueConnectionFactory)JmsTestUtils.lookupObject(ctx, cnnFactoryName);
        String username = (String)props.get("username");
        if (username != null) {
            String password = (String)props.get("password");
            cnn = qcf.createXAQueueConnection(username, password);
        } else {
            cnn = qcf.createXAQueueConnection();
        }
        cnn.start();
        return cnn;
    }

    public static QueueConnection getQueueConnection(Properties props) throws IOException, NamingException, JMSException {
        QueueConnection cnn;
        JmsTestUtils.fixProviderUrl(props);
        String cnnFactoryName = props.getProperty(DEFAULT_JNDI_CONECTION_NAME_PROPERTY);
        if (cnnFactoryName == null) {
            throw new IOException("You must set the property connectionFactoryJNDINamein the JNDI property file");
        }
        InitialContext ctx = new InitialContext(props);
        Object obj = JmsTestUtils.lookupObject(ctx, cnnFactoryName);
        QueueConnectionFactory qcf = (QueueConnectionFactory)obj;
        String username = (String)props.get("username");
        if (username != null) {
            String password = (String)props.get("password");
            cnn = qcf.createQueueConnection(username, password);
        } else {
            cnn = qcf.createQueueConnection();
        }
        cnn.start();
        return cnn;
    }

    public static TopicConnection getTopicConnection() throws IOException, NamingException, JMSException {
        return JmsTestUtils.getTopicConnection(JmsTestUtils.getJmsProperties());
    }

    public static TopicConnection getTopicConnection(Properties props) throws IOException, NamingException, JMSException {
        TopicConnection cnn;
        JmsTestUtils.fixProviderUrl(props);
        String cnnFactoryName = props.getProperty(JNDI_TOPIC_CONECTION_NAME_PROPERTY);
        if (cnnFactoryName == null) {
            throw new IOException("You must set the property connectionFactoryJNDINamein the JNDI property file");
        }
        InitialContext ctx = new InitialContext(props);
        TopicConnectionFactory tcf = (TopicConnectionFactory)JmsTestUtils.lookupObject(ctx, cnnFactoryName);
        String username = (String)props.get("username");
        if (username != null) {
            String password = (String)props.get("password");
            cnn = tcf.createTopicConnection(username, password);
        } else {
            cnn = tcf.createTopicConnection();
        }
        cnn.start();
        return cnn;
    }

    public static Object lookupObject(Context context, String reference) throws NamingException {
        Object ref = context.lookup(reference);
        if (ref instanceof Reference) {
            String className = ((Reference)ref).getClassName();
            try {
                ref = ClassUtils.loadClass((String)className, (Class)JmsTestUtils.class).newInstance();
            }
            catch (Exception e) {
                throw new NamingException("Failed to instanciate class: " + className + ". Exception was: " + e.toString());
            }
        }
        return ref;
    }

    public static XATopicConnection getXATopicConnection() throws IOException, NamingException, JMSException {
        XATopicConnection cnn;
        Properties props = JmsTestUtils.getJmsProperties();
        String cnnFactoryName = props.getProperty(JNDI_XATOPIC_CONECTION_NAME_PROPERTY);
        if (cnnFactoryName == null) {
            throw new IOException("You must set the property XAQueueConnectionFactoryJNDINamein the JNDI property file");
        }
        InitialContext ctx = new InitialContext(props);
        XATopicConnectionFactory tcf = (XATopicConnectionFactory)JmsTestUtils.lookupObject(ctx, cnnFactoryName);
        String username = (String)props.get("username");
        if (username != null) {
            String password = (String)props.get("password");
            cnn = tcf.createXATopicConnection(username, password);
        } else {
            cnn = tcf.createXATopicConnection();
        }
        cnn.start();
        return cnn;
    }

    public static Session getSession(Connection cnn) throws JMSException {
        Object session = cnn instanceof QueueConnection ? ((QueueConnection)cnn).createQueueSession(false, 1) : ((TopicConnection)cnn).createTopicSession(false, 1);
        return session;
    }

    public static XASession getXASession(XAConnection cnn) throws JMSException {
        Object session = cnn instanceof XAQueueConnection ? ((XAQueueConnection)cnn).createXAQueueSession() : ((XATopicConnection)cnn).createXATopicSession();
        return session;
    }

    public static void drainQueue(QueueConnection cnn, String queue) throws Exception {
        QueueSession session = cnn.createQueueSession(false, 1);
        Queue q = session.createQueue(queue);
        QueueReceiver receiver = session.createReceiver(q);
        Message msg = null;
        while ((msg = receiver.receive(1000L)) != null) {
            logger.debug((Object)("Removing message: " + msg));
            msg.acknowledge();
        }
        receiver.close();
        session.close();
    }

    public static void drainTopic(TopicConnection cnn, String topic) throws Exception {
        TopicSession session = cnn.createTopicSession(false, 3);
        Topic t = session.createTopic(topic);
        TopicSubscriber subscriber = session.createSubscriber(t);
        Message msg = subscriber.receiveNoWait();
        while (msg != null) {
            try {
                msg.acknowledge();
            }
            catch (JMSException e) {
                // empty catch block
            }
            msg = subscriber.receiveNoWait();
        }
        subscriber.close();
        session.close();
    }

    public static TextMessage getTextMessage(Connection cnn, String message) throws Exception {
        return JmsTestUtils.getSession(cnn).createTextMessage(message);
    }

    public static void queueSend(QueueConnection cnn, String queueName, String payload, boolean transacted, int ack, String replyTo) throws JMSException {
        QueueSession session = cnn.createQueueSession(transacted, ack);
        Queue queue = session.createQueue(queueName);
        QueueSender sender = session.createSender(queue);
        TextMessage msg = session.createTextMessage();
        msg.setText(payload);
        msg.setJMSDeliveryMode(ack);
        if (replyTo != null) {
            msg.setJMSReplyTo((Destination)session.createQueue(replyTo));
        }
        sender.send((Message)msg);
        sender.close();
        session.close();
    }

    public static void topicPublish(TopicConnection cnn, String topicName, String payload, boolean transacted, int ack) throws JMSException {
        JmsTestUtils.topicPublish(cnn, topicName, payload, transacted, ack, null);
    }

    public static void topicPublish(TopicConnection cnn, String topicName, String payload, boolean transacted, int ack, String replyTo) throws JMSException {
        TopicSession session = cnn.createTopicSession(transacted, ack);
        Topic topic = session.createTopic(topicName);
        TopicPublisher publisher = session.createPublisher(topic);
        TextMessage msg = session.createTextMessage();
        msg.setText(payload);
        msg.setJMSDeliveryMode(ack);
        if (replyTo != null) {
            msg.setJMSReplyTo((Destination)session.createTopic(replyTo));
        }
        publisher.publish((Message)msg);
        publisher.close();
        session.close();
    }

    public static Message queueReceiver(QueueConnection cnn, String queueName, long timeout) throws JMSException {
        Queue queue;
        QueueSession session = cnn.createQueueSession(false, 1);
        QueueReceiver receiver = session.createReceiver(queue = session.createQueue(queueName));
        Message msg = receiver.receive(timeout);
        if (msg != null) {
            msg.acknowledge();
        }
        receiver.close();
        session.close();
        return msg;
    }

    public static Message topicSubscribe(TopicConnection cnn, String topicName, long timeout) throws JMSException {
        TopicSubscriber receiver = JmsTestUtils.getTopicSubscriber(cnn, topicName);
        Message msg = receiver.receive(timeout);
        if (msg != null) {
            msg.acknowledge();
        }
        receiver.close();
        return msg;
    }

    public static TopicSubscriber getTopicSubscriber(TopicConnection cnn, String topicName) throws JMSException {
        TopicSession session = cnn.createTopicSession(false, 1);
        Topic topic = session.createTopic(topicName);
        TopicSubscriber receiver = session.createSubscriber(topic);
        return receiver;
    }

    public static QueueReceiver getQueueReceiver(QueueConnection cnn, String queueName) throws JMSException {
        QueueSession session = cnn.createQueueSession(false, 1);
        Queue queue = session.createQueue(queueName);
        QueueReceiver receiver = session.createReceiver(queue);
        return receiver;
    }
}

