/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms.transactions;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import javax.jms.Message;
import javax.jms.TextMessage;
import junit.framework.Assert;
import org.mule.providers.jms.functional.AbstractJmsFunctionalTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOTransaction;

public abstract class AbstractJmsTransactionFunctionalTest
extends AbstractJmsFunctionalTestCase {
    public static final int SEND_NOT_TRANSACTED = 1;
    public static final int SEND_TRANSACTED_ALWAYS = 2;
    public static final int SEND_TRANSACTED_IF_POSSIBLE_WITH_TRANSACTION = 4;
    public static final int SEND_TRANSACTED_IF_POSSIBLE_WITHOUT_TRANSACTION = 8;
    public static final int SEND_TRANSACTED_ROLLBACK = 16;
    public static final int CLEANUP = 32;
    public static final int TRANSACTED_REDELIVERY_TO_DL_DESTINATION = 64;
    public static final int ALL = 65535;
    protected volatile UMOTransaction currentTx;
    protected int exclusionFlag = 0;

    protected void exclude(int flag) {
        this.exclusionFlag = flag;
    }

    protected boolean notExcluded(int flag) {
        boolean excluded;
        boolean bl = excluded = (flag & this.exclusionFlag) != 0;
        if (excluded) {
            this.logger.warn((Object)"Excluding this test");
        }
        return !excluded;
    }

    protected String getBaseConfigResources() {
        return "jms-transaction.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.currentTx = null;
    }

    protected void doTearDown() throws Exception {
        TransactionCoordination.getInstance().unbindTransaction(TransactionCoordination.getInstance().getTransaction());
        super.doTearDown();
        AbstractJmsTransactionFunctionalTest.assertNull((String)"There should be no transaction associated with this thread", (Object)TransactionCoordination.getInstance().getTransaction());
    }

    public void testSendNotTransacted() throws Exception {
        EventCallback callback = new EventCallback(){

            public synchronized void eventReceived(UMOEventContext context, Object component) throws Exception {
                AbstractJmsTransactionFunctionalTest.this.currentTx = context.getCurrentTransaction();
                Assert.assertNull((Object)AbstractJmsTransactionFunctionalTest.this.currentTx);
                AbstractJmsTransactionFunctionalTest.this.callbackCalled.countDown();
            }
        };
        Object ftc = this.getPojoServiceForComponent("component1");
        AbstractJmsTransactionFunctionalTest.assertTrue((String)"FunctionalTestComponent expected", (boolean)(ftc instanceof FunctionalTestComponent));
        ((FunctionalTestComponent)ftc).setEventCallback(callback);
        this.send("Test Message", "component1In");
        AbstractJmsTransactionFunctionalTest.assertTrue((boolean)this.callbackCalled.await(30000L, TimeUnit.MILLISECONDS));
        AbstractJmsTransactionFunctionalTest.assertEquals((Object)"Test Message", (Object)((FunctionalTestComponent)ftc).getLastReceivedMessage());
        AbstractJmsTransactionFunctionalTest.assertNull((Object)this.currentTx);
        AbstractJmsTransactionFunctionalTest.assertEquals((String)TEST_MESSAGE_RESPONSE, (String)this.receiveTextMessage("component1Out"));
    }

    public void testSendTransactedAlways() throws Exception {
        EventCallback callback = new EventCallback(){

            public synchronized void eventReceived(UMOEventContext context, Object component) throws Exception {
                AbstractJmsTransactionFunctionalTest.this.currentTx = context.getCurrentTransaction();
                Assert.assertNotNull((Object)AbstractJmsTransactionFunctionalTest.this.currentTx);
                Assert.assertTrue((boolean)AbstractJmsTransactionFunctionalTest.this.currentTx.isBegun());
                AbstractJmsTransactionFunctionalTest.this.callbackCalled.countDown();
            }
        };
        Object ftc = this.getPojoServiceForComponent("component2");
        AbstractJmsTransactionFunctionalTest.assertTrue((String)"FunctionalTestComponent expected", (boolean)(ftc instanceof FunctionalTestComponent));
        ((FunctionalTestComponent)ftc).setEventCallback(callback);
        this.send("Test Message", "component2In");
        AbstractJmsTransactionFunctionalTest.assertTrue((boolean)this.callbackCalled.await(30000L, TimeUnit.MILLISECONDS));
        AbstractJmsTransactionFunctionalTest.assertEquals((Object)"Test Message", (Object)((FunctionalTestComponent)ftc).getLastReceivedMessage());
        AbstractJmsTransactionFunctionalTest.assertEquals((String)TEST_MESSAGE_RESPONSE, (String)this.receiveTextMessage("component1Out"));
        AbstractJmsTransactionFunctionalTest.assertTrue((boolean)this.currentTx.isBegun());
        Thread.sleep(1000L);
        AbstractJmsTransactionFunctionalTest.assertTrue((boolean)this.currentTx.isCommitted());
    }

    public void testSendTransactedRollback() throws Exception {
        EventCallback callback = new EventCallback(){

            public synchronized void eventReceived(UMOEventContext context, Object component) throws Exception {
                AbstractJmsTransactionFunctionalTest.this.currentTx = context.getCurrentTransaction();
                Assert.assertNotNull((Object)AbstractJmsTransactionFunctionalTest.this.currentTx);
                Assert.assertTrue((boolean)AbstractJmsTransactionFunctionalTest.this.currentTx.isBegun());
                AbstractJmsTransactionFunctionalTest.this.logger.info((Object)"@@@@ Rolling back transaction @@@@");
                AbstractJmsTransactionFunctionalTest.this.currentTx.setRollbackOnly();
                AbstractJmsTransactionFunctionalTest.this.callbackCalled.countDown();
            }
        };
        Object ftc = this.getPojoServiceForComponent("component2");
        AbstractJmsTransactionFunctionalTest.assertTrue((String)"FunctionalTestComponent expected", (boolean)(ftc instanceof FunctionalTestComponent));
        ((FunctionalTestComponent)ftc).setEventCallback(callback);
        this.send("Test Message", "component2In");
        AbstractJmsTransactionFunctionalTest.assertTrue((boolean)this.callbackCalled.await(30000L, TimeUnit.MILLISECONDS));
        AbstractJmsTransactionFunctionalTest.assertEquals((Object)"Test Message", (Object)((FunctionalTestComponent)ftc).getLastReceivedMessage());
        AbstractJmsTransactionFunctionalTest.assertTrue((boolean)this.currentTx.isBegun());
        Thread.sleep(1000L);
        AbstractJmsTransactionFunctionalTest.assertTrue((boolean)this.currentTx.isRolledBack());
        AbstractJmsTransactionFunctionalTest.assertNull((String)"Transaction was rolled back, but message got delivered anyways.", (Object)this.receive("component2Out", 1000L));
    }

    public void testTransactedRedeliveryToDLDestination() throws Exception {
        EventCallback callback = new EventCallback(){

            public synchronized void eventReceived(UMOEventContext context, Object component) throws Exception {
                AbstractJmsTransactionFunctionalTest.this.currentTx = context.getCurrentTransaction();
                Assert.assertNotNull((Object)AbstractJmsTransactionFunctionalTest.this.currentTx);
                Assert.assertTrue((boolean)AbstractJmsTransactionFunctionalTest.this.currentTx.isBegun());
                AbstractJmsTransactionFunctionalTest.this.logger.info((Object)"@@@@ Rolling back transaction @@@@");
                AbstractJmsTransactionFunctionalTest.this.currentTx.setRollbackOnly();
                AbstractJmsTransactionFunctionalTest.this.callbackCalled.countDown();
            }
        };
        Object ftc = this.getPojoServiceForComponent("component3");
        AbstractJmsTransactionFunctionalTest.assertTrue((String)"FunctionalTestComponent expected", (boolean)(ftc instanceof FunctionalTestComponent));
        ((FunctionalTestComponent)ftc).setEventCallback(callback);
        this.send("Test Message", "component3In");
        AbstractJmsTransactionFunctionalTest.assertTrue((boolean)this.callbackCalled.await(30000L, TimeUnit.MILLISECONDS));
        AbstractJmsTransactionFunctionalTest.assertEquals((Object)"Test Message", (Object)((FunctionalTestComponent)ftc).getLastReceivedMessage());
        AbstractJmsTransactionFunctionalTest.assertTrue((boolean)this.currentTx.isBegun());
        Thread.sleep(1000L);
        AbstractJmsTransactionFunctionalTest.assertTrue((boolean)this.currentTx.isRolledBack());
        AbstractJmsTransactionFunctionalTest.assertNull((String)"Transaction was rolled back, but message got delivered anyways.", (Object)this.receive("component3Out", 1000L));
        Message dl = this.receive("dead.letter");
        AbstractJmsTransactionFunctionalTest.assertNotNull((Object)dl);
        AbstractJmsTransactionFunctionalTest.assertTrue((boolean)(dl instanceof TextMessage));
        AbstractJmsTransactionFunctionalTest.assertEquals((String)TEST_MESSAGE_RESPONSE, (String)((TextMessage)dl).getText());
        String dest = dl.getStringProperty("MULE_ENDPOINT");
        AbstractJmsTransactionFunctionalTest.assertNotNull((Object)dest);
        AbstractJmsTransactionFunctionalTest.assertEquals((String)"jms://dead.letter", (String)dest);
    }
}

