/*
 * $Id: ActiveMQXAJmsConnector.java 10489 2008-01-23 17:53:38Z dfeist $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.transport.jms.activemq;

import org.mule.util.ClassUtils;

import javax.jms.ConnectionFactory;

public class ActiveMQXAJmsConnector extends ActiveMQJmsConnector
{
    public static final String ACTIVEMQ_XA_CONNECTION_FACTORY_CLASS = "org.apache.activemq.ActiveMQXAConnectionFactory";

    protected ConnectionFactory getDefaultConnectionFactory()
    {
        try
        {
            return (ConnectionFactory) 
                ClassUtils.instanciateClass(ACTIVEMQ_XA_CONNECTION_FACTORY_CLASS, new Object[]{getBrokerURL()});
        }
        catch (Exception e)
        {
            logger.warn(e);
            return null;
        }
    }
}
