/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;

public class JmsXAAlwaysBeginTestCase
extends AbstractJmsFunctionalTestCase {
    private static final List committedTx = new CopyOnWriteArrayList();
    private static final List rolledbackTx = new CopyOnWriteArrayList();
    protected static final Log logger = LogFactory.getLog(JmsXAAlwaysBeginTestCase.class);

    protected String getConfigResources() {
        return "providers/activemq/jms-xa-tx-ALWAYS_BEGIN.xml";
    }

    public void testAlwaysBeginTx() throws Exception {
        CurrentScenario scenarioNoTx = new CurrentScenario("in", "out", true);
        this.send(scenarioNoTx);
        this.receive(scenarioNoTx);
        this.receive(scenarioNoTx);
        scenarioNoTx.setRecieve(false);
        this.receive(scenarioNoTx);
        JmsXAAlwaysBeginTestCase.assertEquals((int)committedTx.size(), (int)0);
        JmsXAAlwaysBeginTestCase.assertEquals((int)rolledbackTx.size(), (int)2);
    }

    class CurrentScenario
    extends AbstractJmsFunctionalTestCase.AbstractScenario {
        private String inputQueue;
        private String outputQueue;
        private boolean recieve = true;

        public CurrentScenario(String inputQueue, String outputQueue, boolean recieve) {
            this.inputQueue = inputQueue;
            this.outputQueue = outputQueue;
        }

        public String getInputQueue() {
            return this.inputQueue;
        }

        public String getOutputQueue() {
            return this.outputQueue;
        }

        public boolean isRecieve() {
            return this.recieve;
        }

        public void setRecieve(boolean recieve) {
            this.recieve = recieve;
        }

        public void send(Session session, MessageProducer producer) throws JMSException {
            producer.send((Message)session.createTextMessage("INPUT MESSAGE"));
        }

        public Message receive(Session session, MessageConsumer consumer) throws JMSException {
            Message message = consumer.receive(5000L);
            if (this.isRecieve()) {
                Assert.assertNotNull((Object)message);
                Assert.assertTrue((boolean)TextMessage.class.isAssignableFrom(message.getClass()));
                Assert.assertEquals((String)((TextMessage)message).getText(), (String)"OUTPUT MESSAGE");
            } else {
                Assert.assertNull((Object)message);
            }
            return message;
        }

        public boolean isTransacted() {
            return false;
        }

        protected void applyTransaction(Session session) throws JMSException {
        }
    }

    public static class TestResource
    implements XAResource {
        protected int _timeout = 0;

        public void commit(Xid id, boolean onePhase) throws XAException {
            committedTx.add(id);
            logger.debug((Object)("XA_COMMIT[" + id + "]"));
        }

        public void end(Xid xid, int flags) throws XAException {
            logger.debug((Object)("XA_END[" + xid + "] Flags=" + flags));
        }

        public void forget(Xid xid) throws XAException {
            logger.debug((Object)("XA_FORGET[" + xid + "]"));
        }

        public int getTransactionTimeout() throws XAException {
            return this._timeout;
        }

        public boolean isSameRM(XAResource xares) throws XAException {
            return xares.equals(this);
        }

        public int prepare(Xid xid) throws XAException {
            logger.debug((Object)("XA_PREPARE[" + xid + "]"));
            return 0;
        }

        public Xid[] recover(int flag) throws XAException {
            logger.debug((Object)("RECOVER[" + flag + "]"));
            return null;
        }

        public void rollback(Xid xid) throws XAException {
            rolledbackTx.add(xid);
            logger.debug((Object)("XA_ROLLBACK[" + xid + "]"));
        }

        public boolean setTransactionTimeout(int seconds) throws XAException {
            this._timeout = seconds;
            return true;
        }

        public void start(Xid xid, int flags) throws XAException {
            logger.debug((Object)("XA_START[" + xid + "] Flags=" + flags));
        }
    }

    public static class TestRollbackComponent {
        public Object processObject(Object a) throws Exception {
            logger.debug((Object)("TestRollbackComponent " + a));
            TestResource res = new TestResource();
            Transaction currentTrans = muleContext.getTransactionManager().getTransaction();
            currentTrans.enlistResource((XAResource)res);
            currentTrans.setRollbackOnly();
            return "OUTPUT MESSAGE";
        }
    }
}

