/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.issues;

import javax.jms.ConnectionFactory;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageAwareTransformer;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;
import org.mule.transport.jms.transformers.ObjectToJMSMessage;

public class MessageAwareTransformersMule2685TestCase
extends AbstractJmsFunctionalTestCase {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Session session = null;

    protected String getConfigResources() {
        return "activemq-config.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        JmsConnector connector = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsConnector");
        ConnectionFactory cf = connector.getConnectionFactory();
        this.session = cf.createConnection().createSession(false, 1);
    }

    protected void doTearDown() throws Exception {
        RequestContext.setEvent(null);
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    public void testMessageAwareTransformerChainedWithObjectToJMSMessage() throws Exception {
        RequestContext.setEvent((MuleEvent)MessageAwareTransformersMule2685TestCase.getTestEvent((Object)"test"));
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"This is a test TextMessage");
        SetTestRecipientsTransformer trans = new SetTestRecipientsTransformer();
        MuleMessage result1 = (MuleMessage)trans.transform(message);
        MessageAwareTransformersMule2685TestCase.assertEquals((Object)"vm://recipient1, vm://recipient1, vm://recipient3", (Object)result1.getProperty("recipients"));
        SessionEnabledObjectToJMSMessage trans2 = new SessionEnabledObjectToJMSMessage(this.session);
        Message result2 = (Message)trans2.transform(result1);
        MessageAwareTransformersMule2685TestCase.assertTrue((String)"Transformed object should be a TextMessage", (boolean)(result2 instanceof TextMessage));
        MessageAwareTransformersMule2685TestCase.assertEquals((String)"This is a test TextMessage", (String)((TextMessage)result2).getText());
        MessageAwareTransformersMule2685TestCase.assertEquals((String)"vm://recipient1, vm://recipient1, vm://recipient3", (String)result2.getStringProperty("recipients"));
    }

    private class SetTestRecipientsTransformer
    extends AbstractMessageAwareTransformer {
        public SetTestRecipientsTransformer() {
            this.registerSourceType(MuleMessage.class);
        }

        public Object transform(MuleMessage message, String outputEncoding) throws TransformerException {
            String recipients = "vm://recipient1, vm://recipient1, vm://recipient3";
            this.logger.debug((Object)("Setting recipients to '" + recipients + "'"));
            message.setProperty("recipients", (Object)recipients);
            return message;
        }
    }

    public static class SessionEnabledObjectToJMSMessage
    extends ObjectToJMSMessage {
        private final Session transformerSession;

        public SessionEnabledObjectToJMSMessage(Session session) {
            this.transformerSession = session;
        }

        protected Session getSession() {
            return this.transformerSession;
        }
    }
}

