/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.vendors;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.mule.tck.FunctionalTestCase;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.xa.ConnectionFactoryWrapper;
import org.mule.transport.jms.xa.ConnectionInvocationHandler;

public class ActiveMQXaJmsConnectorTestCase
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "activemq-xa.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReflectiveXaCleanup() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsConnector");
        ActiveMQXaJmsConnectorTestCase.assertNotNull((Object)c);
        ConnectionFactory cf = c.getConnectionFactory();
        ActiveMQXaJmsConnectorTestCase.assertTrue((boolean)(cf instanceof ActiveMQXAConnectionFactory));
        ConnectionFactoryWrapper wrapper = new ConnectionFactoryWrapper((Object)cf);
        Connection connection = wrapper.createConnection();
        ActiveMQXaJmsConnectorTestCase.assertNotNull((Object)connection);
        ActiveMQXaJmsConnectorTestCase.assertTrue((boolean)Proxy.isProxyClass(connection.getClass()));
        try {
            Method cleanupMethod;
            Class<?> clazz = connection.getClass();
            if (Proxy.isProxyClass(clazz)) {
                ConnectionInvocationHandler handler = (ConnectionInvocationHandler)Proxy.getInvocationHandler(connection);
                connection = (Connection)handler.getTargetObject();
                Class<?> realConnectionClass = connection.getClass();
                cleanupMethod = realConnectionClass.getMethod("cleanup", null);
            } else {
                cleanupMethod = clazz.getMethod("cleanup", null);
            }
            if (cleanupMethod != null) {
                cleanupMethod.invoke((Object)connection, null);
            }
        }
        finally {
            connection.close();
        }
    }
}

