/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.util.List;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.DispatchException;
import org.mule.service.AbstractService;
import org.mule.transport.DefaultReplyToHandler;
import org.mule.transport.jms.Jms102bSupport;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.JmsMessageUtils;
import org.mule.transport.jms.i18n.JmsMessages;
import org.mule.util.StringMessageUtils;

public class JmsReplyToHandler
extends DefaultReplyToHandler {
    private final JmsConnector connector;

    public JmsReplyToHandler(JmsConnector connector, List transformers) {
        super(transformers);
        this.connector = connector;
    }

    public void processReplyTo(MuleEvent event, MuleMessage returnMessage, Object replyTo) throws MuleException {
        Destination replyToDestination = null;
        MessageProducer replyToProducer = null;
        Session session = null;
        try {
            if (replyTo instanceof Destination) {
                replyToDestination = (Destination)replyTo;
            }
            if (replyToDestination == null) {
                super.processReplyTo(event, returnMessage, replyTo);
                return;
            }
            Class<?> srcType = returnMessage.getPayload().getClass();
            for (Transformer t : this.getTransformers()) {
                if (!t.isSourceTypeSupported(srcType) || t.getEndpoint() != null) continue;
                t.setEndpoint(this.getEndpoint(event, "jms://temporary"));
                break;
            }
            returnMessage.applyTransformers(this.getTransformers());
            Object payload = returnMessage.getPayload();
            if (replyToDestination instanceof Topic && replyToDestination instanceof Queue && this.connector.getJmsSupport() instanceof Jms102bSupport) {
                logger.error((Object)StringMessageUtils.getBoilerPlate((String)"ReplyTo destination implements both Queue and Topic while complying with JMS 1.0.2b specification. Please report your application server or JMS vendor name and version to dev<_at_>mule.codehaus.org or http://mule.mulesource.org/jira"));
            }
            boolean topic = this.connector.getTopicResolver().isTopic(replyToDestination);
            session = this.connector.getSession(false, topic);
            Message replyToMessage = JmsMessageUtils.toMessage(payload, session);
            replyToMessage.setJMSReplyTo(null);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sending jms reply to: " + replyToDestination + "(" + replyToDestination.getClass().getName() + ")"));
            }
            replyToProducer = this.connector.getJmsSupport().createProducer(session, replyToDestination, topic);
            MuleMessage eventMsg = event.getMessage();
            String ttlString = (String)eventMsg.removeProperty("timeToLive");
            String priorityString = (String)eventMsg.removeProperty("priority");
            String persistentDeliveryString = (String)eventMsg.removeProperty("persistentDelivery");
            if (ttlString == null && priorityString == null && persistentDeliveryString == null) {
                this.connector.getJmsSupport().send(replyToProducer, replyToMessage, topic);
            } else {
                long ttl = 0L;
                int priority = 4;
                boolean persistent = true;
                if (ttlString != null) {
                    ttl = Long.parseLong(ttlString);
                }
                if (priorityString != null) {
                    priority = Integer.parseInt(priorityString);
                }
                persistent = persistentDeliveryString != null ? Boolean.valueOf(persistentDeliveryString).booleanValue() : this.connector.isPersistentDelivery();
                this.connector.getJmsSupport().send(replyToProducer, replyToMessage, persistent, priority, ttl, topic);
            }
            logger.info((Object)("Reply Message sent to: " + replyToDestination));
            ((AbstractService)event.getService()).getStatistics().incSentReplyToEvent();
            this.connector.closeQuietly(replyToProducer);
            this.connector.closeQuietly(session);
        }
        catch (Exception e) {
            throw new DispatchException(JmsMessages.failedToCreateAndDispatchResponse(replyToDestination), returnMessage, null, (Throwable)e);
        }
        finally {
            this.connector.closeQuietly(replyToProducer);
            this.connector.closeQuietly(session);
        }
    }
}

