/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import org.mule.api.transaction.TransactionException;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.transaction.AbstractSingleResourceTransaction;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transport.jms.i18n.JmsMessages;

public class JmsTransaction
extends AbstractSingleResourceTransaction {
    public void bindResource(Object key, Object resource) throws TransactionException {
        if (!(key instanceof Connection) || !(resource instanceof Session)) {
            throw new IllegalTransactionStateException(CoreMessages.transactionCanOnlyBindToResources((String)"javax.jms.Connection/javax.jms.Session"));
        }
        Session session = (Session)resource;
        try {
            if (!session.getTransacted()) {
                throw new IllegalTransactionStateException(JmsMessages.sessionShouldBeTransacted());
            }
        }
        catch (JMSException e) {
            throw new IllegalTransactionStateException(CoreMessages.transactionCannotReadState(), (Throwable)e);
        }
        super.bindResource(key, resource);
    }

    protected void doBegin() throws TransactionException {
    }

    protected void doCommit() throws TransactionException {
        try {
            ((Session)this.resource).commit();
        }
        catch (JMSException e) {
            throw new TransactionException(CoreMessages.transactionCommitFailed(), (Throwable)e);
        }
    }

    protected void doRollback() throws TransactionException {
        if (this.resource != null) {
            try {
                ((Session)this.resource).rollback();
            }
            catch (JMSException e) {
                throw new TransactionException(CoreMessages.transactionRollbackFailed(), (Throwable)e);
            }
        } else {
            throw new TransactionException(MessageFactory.createStaticMessage((String)"No resource has been bound to this transaction"));
        }
    }
}

