/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.transformers;

import javax.jms.Message;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transport.jms.transformers.AbstractJmsTransformer;
import org.mule.util.ClassUtils;

public class JMSMessageToObject
extends AbstractJmsTransformer {
    public JMSMessageToObject() {
        this.registerSourceType(Message.class);
    }

    public Object transform(MuleMessage message, String outputEncoding) throws TransformerException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Source object is " + ClassUtils.getSimpleName(message.getPayload().getClass())));
            }
            Object result = this.transformFromMessage((Message)message.getPayload());
            if (this.returnClass != null) {
                if (this.returnClass.equals(byte[].class) && result instanceof String) {
                    result = result.toString().getBytes(outputEncoding);
                } else if (this.returnClass.equals(String.class) && result instanceof byte[]) {
                    result = new String((byte[])result, outputEncoding);
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Resulting object is " + ClassUtils.getSimpleName(result.getClass())));
            }
            return result;
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }
}

