/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import junit.framework.Assert;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;

public class JmsClientAcknowledgeTransactionTestCase
extends AbstractJmsFunctionalTestCase {
    AbstractJmsFunctionalTestCase.Scenario scenarioAcknowledge = new AbstractJmsFunctionalTestCase.NonTransactedScenario(){

        public int getAcknowledge() {
            return 2;
        }

        public void send(Session session, MessageProducer producer) throws JMSException {
            producer.send((Message)session.createTextMessage("INPUT MESSAGE"));
        }

        public Message receive(Session session, MessageConsumer consumer) throws JMSException {
            Message message = consumer.receive(5000L);
            Assert.assertNotNull((Object)message);
            message.acknowledge();
            return message;
        }
    };
    AbstractJmsFunctionalTestCase.Scenario scenarioWithoutAcknowledge = new AbstractJmsFunctionalTestCase.NonTransactedScenario(){

        public int getAcknowledge() {
            return 2;
        }
    };

    protected String getConfigResources() {
        return "providers/activemq/jms-client-acknowledge-tx.xml";
    }

    public void testJmsClientAcknowledgeTransaction() throws Exception {
        this.send(this.scenarioAcknowledge);
        this.receive(this.scenarioWithoutAcknowledge);
        this.receive(this.scenarioAcknowledge);
        this.receive(this.scenarioNotReceive);
    }
}

