/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.ConnectionFactory;
import javax.jms.MapMessage;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;
import org.mule.transport.jms.transformers.JMSMessageToObject;
import org.mule.transport.jms.transformers.ObjectToJMSMessage;
import org.mule.util.FileUtils;
import org.mule.util.compression.GZipCompression;

public class JmsTransformersTestCase
extends AbstractJmsFunctionalTestCase {
    private Session session = null;

    protected String getConfigResources() {
        return "activemq-config.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        JmsConnector connector = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsConnector");
        ConnectionFactory cf = connector.getConnectionFactory();
        this.session = cf.createConnection().createSession(false, 1);
    }

    protected void doTearDown() throws Exception {
        RequestContext.setEvent(null);
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    public void testTransformObjectMessage() throws Exception {
        RequestContext.setEvent((MuleEvent)JmsTransformersTestCase.getTestEvent((Object)"test"));
        ObjectMessage oMsg = this.session.createObjectMessage();
        File f = FileUtils.newFile((String)"/some/random/path");
        oMsg.setObject((Serializable)f);
        JMSMessageToObject trans = new JMSMessageToObject();
        Object result = trans.transform((Object)oMsg);
        JmsTransformersTestCase.assertTrue((String)"Transformed object should be a File", (boolean)result.getClass().equals(File.class));
        SessionEnabledObjectToJMSMessage trans2 = new SessionEnabledObjectToJMSMessage(this.session);
        trans2.setReturnClass(ObjectMessage.class);
        Object result2 = trans2.transform(f);
        JmsTransformersTestCase.assertTrue((String)"Transformed object should be an object message", (boolean)(result2 instanceof ObjectMessage));
    }

    public void testTransformTextMessage() throws Exception {
        RequestContext.setEvent((MuleEvent)JmsTransformersTestCase.getTestEvent((Object)"test"));
        String text = "This is a test TextMessage";
        TextMessage tMsg = this.session.createTextMessage();
        tMsg.setText(text);
        JMSMessageToObject trans = new JMSMessageToObject();
        Object result = trans.transform((Object)tMsg);
        JmsTransformersTestCase.assertTrue((String)"Transformed object should be a string", (boolean)text.equals(result.toString()));
        SessionEnabledObjectToJMSMessage trans2 = new SessionEnabledObjectToJMSMessage(this.session);
        trans2.setReturnClass(TextMessage.class);
        Object result2 = trans2.transform(text);
        JmsTransformersTestCase.assertTrue((String)"Transformed object should be a TextMessage", (boolean)(result2 instanceof TextMessage));
    }

    public void testTransformMapMessage() throws Exception {
        RequestContext.setEvent((MuleEvent)JmsTransformersTestCase.getTestEvent((Object)"test"));
        Properties p = new Properties();
        p.setProperty("Key1", "Value1");
        p.setProperty("Key2", "Value2");
        p.setProperty("Key3", "Value3");
        SessionEnabledObjectToJMSMessage trans = new SessionEnabledObjectToJMSMessage(this.session);
        trans.setReturnClass(MapMessage.class);
        Object result2 = trans.transform(p);
        JmsTransformersTestCase.assertTrue((String)"Transformed object should be a MapMessage", (boolean)(result2 instanceof MapMessage));
        MapMessage mMsg = (MapMessage)result2;
        JMSMessageToObject trans2 = new JMSMessageToObject();
        trans2.setReturnClass(Map.class);
        Object result = trans2.transform((Object)mMsg);
        JmsTransformersTestCase.assertTrue((String)"Transformed object should be a Map", (boolean)(result instanceof Map));
    }

    public void testTransformByteMessage() throws Exception {
        RequestContext.setEvent((MuleEvent)JmsTransformersTestCase.getTestEvent((Object)"test"));
        SessionEnabledObjectToJMSMessage trans = new SessionEnabledObjectToJMSMessage(this.session);
        trans.setReturnClass(BytesMessage.class);
        String text = "This is a test BytesMessage";
        Object result2 = trans.transform(text.getBytes());
        JmsTransformersTestCase.assertTrue((String)"Transformed object should be a BytesMessage", (boolean)(result2 instanceof BytesMessage));
        JMSMessageToObject trans2 = new JMSMessageToObject();
        trans2.setReturnClass(byte[].class);
        BytesMessage bMsg = (BytesMessage)result2;
        Object result = trans2.transform((Object)bMsg);
        JmsTransformersTestCase.assertTrue((String)"Transformed object should be a byte[]", (boolean)(result instanceof byte[]));
        String res = new String((byte[])result);
        JmsTransformersTestCase.assertEquals((String)"Source and result should be equal", (String)text, (String)res);
    }

    public void testCompressedBytesMessage() throws Exception {
        RequestContext.setEvent((MuleEvent)JmsTransformersTestCase.getTestEvent((Object)"test"));
        GZipCompression compressor = new GZipCompression();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < 5000; ++i) {
            baos.write(i);
        }
        byte[] originalBytes = baos.toByteArray();
        byte[] compressedBytes = compressor.compressByteArray(originalBytes);
        JmsTransformersTestCase.assertTrue((String)"Source compressedBytes should be compressed", (boolean)compressor.isCompressed(compressedBytes));
        SessionEnabledObjectToJMSMessage trans = new SessionEnabledObjectToJMSMessage(this.session);
        trans.setReturnClass(BytesMessage.class);
        Object result2 = trans.transform(compressedBytes);
        JmsTransformersTestCase.assertTrue((String)"Transformed object should be a Bytes message", (boolean)(result2 instanceof BytesMessage));
        BytesMessage intermediate = (BytesMessage)result2;
        intermediate.reset();
        byte[] intermediateBytes = new byte[(int)intermediate.getBodyLength()];
        int intermediateSize = intermediate.readBytes(intermediateBytes);
        JmsTransformersTestCase.assertTrue((String)"Intermediate bytes must be compressed", (boolean)compressor.isCompressed(intermediateBytes));
        JmsTransformersTestCase.assertTrue((String)"Intermediate bytes must be equal to compressed source", (boolean)Arrays.equals(compressedBytes, intermediateBytes));
        JmsTransformersTestCase.assertEquals((String)"Intermediate bytes and compressed source must have same size", (int)compressedBytes.length, (int)intermediateSize);
        JMSMessageToObject trans2 = new JMSMessageToObject();
        trans2.setReturnClass(byte[].class);
        BytesMessage bMsg = this.session.createBytesMessage();
        bMsg.writeBytes(compressedBytes);
        Object result = trans2.transform((Object)bMsg);
        JmsTransformersTestCase.assertTrue((String)"Transformed object should be a byte[]", (boolean)(result instanceof byte[]));
        JmsTransformersTestCase.assertTrue((String)"Result should be compressed", (boolean)compressor.isCompressed((byte[])result));
        JmsTransformersTestCase.assertTrue((String)"Source and result should be equal", (boolean)Arrays.equals(compressedBytes, (byte[])result));
    }

    public static class SessionEnabledObjectToJMSMessage
    extends ObjectToJMSMessage {
        private final Session transformerSession;

        public SessionEnabledObjectToJMSMessage(Session session) {
            this.transformerSession = session;
        }

        protected Session getSession() {
            return this.transformerSession;
        }
    }
}

