/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.transport.AbstractMessageRequester;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.JmsSupport;

public class JmsMessageRequester
extends AbstractMessageRequester {
    private JmsConnector connector;

    public JmsMessageRequester(InboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (JmsConnector)endpoint.getConnector();
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected MuleMessage doRequest(long timeout) throws Exception {
        Message message;
        MessageConsumer consumer;
        Session session;
        block6: {
            session = null;
            consumer = null;
            boolean topic = this.connector.getTopicResolver().isTopic(this.endpoint);
            JmsSupport support = this.connector.getJmsSupport();
            session = this.connector.getSession(false, topic);
            Destination dest = support.createDestination(session, this.endpoint.getEndpointURI().getAddress(), topic);
            consumer = support.createConsumer(session, dest, topic);
            message = timeout == -1L ? consumer.receiveNoWait() : (timeout == 0L ? consumer.receive() : consumer.receive(timeout));
            if (message != null) break block6;
            MuleMessage muleMessage = null;
            this.connector.closeQuietly(consumer);
            this.connector.closeQuietly(session);
            return muleMessage;
        }
        message = this.connector.preProcessMessage(message, session);
        DefaultMuleMessage defaultMuleMessage = new DefaultMuleMessage((Object)this.connector.getMessageAdapter(message));
        this.connector.closeQuietly(consumer);
        this.connector.closeQuietly(session);
        return defaultMuleMessage;
        {
            catch (Exception e) {
                try {
                    this.connector.handleException(e);
                    MuleMessage muleMessage = null;
                    this.connector.closeQuietly(consumer);
                    this.connector.closeQuietly(session);
                    return muleMessage;
                }
                catch (Throwable throwable) {
                    this.connector.closeQuietly(consumer);
                    this.connector.closeQuietly(session);
                    throw throwable;
                }
            }
        }
    }

    protected void doDispose() {
    }
}

