/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.xa;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicSession;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import org.mule.transaction.XaTransaction;
import org.mule.transport.jms.xa.ConnectionFactoryWrapper;
import org.mule.transport.jms.xa.SessionInvocationHandler;

public class ConnectionInvocationHandler
implements InvocationHandler {
    private Object xaConnection;

    public ConnectionInvocationHandler(Object xac) {
        this.xaConnection = xac;
    }

    public Object getTargetObject() {
        return this.xaConnection;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (ConnectionFactoryWrapper.logger.isDebugEnabled()) {
            ConnectionFactoryWrapper.logger.debug((Object)("Invoking " + method));
        }
        if (method.getName().equals("createSession")) {
            XASession xas = ((XAConnection)this.xaConnection).createXASession();
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Session.class, XaTransaction.MuleXaObject.class}, (InvocationHandler)new SessionInvocationHandler(xas));
        }
        if (method.getName().equals("createQueueSession")) {
            XAQueueSession xaqs = ((XAQueueConnection)this.xaConnection).createXAQueueSession();
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{QueueSession.class, XaTransaction.MuleXaObject.class}, (InvocationHandler)new SessionInvocationHandler(xaqs));
        }
        if (method.getName().equals("createTopicSession")) {
            XATopicSession xats = ((XATopicConnection)this.xaConnection).createXATopicSession();
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{TopicSession.class, XaTransaction.MuleXaObject.class}, (InvocationHandler)new SessionInvocationHandler(xats));
        }
        return method.invoke(this.xaConnection, args);
    }
}

