/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import com.mockobjects.constraint.IsInstanceOf;
import com.mockobjects.dynamic.Mock;
import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transport.jms.JmsMessageUtils;

public class JmsMessageUtilsTestCase
extends AbstractMuleTestCase {
    public void testHeaders() {
        JmsMessageUtilsTestCase.assertSame((Object)"identifier", (Object)JmsMessageUtils.encodeHeader((String)"identifier"));
        JmsMessageUtilsTestCase.assertSame((Object)"_identifier", (Object)JmsMessageUtils.encodeHeader((String)"_identifier"));
        JmsMessageUtilsTestCase.assertSame((Object)"identifier_", (Object)JmsMessageUtils.encodeHeader((String)"identifier_"));
        JmsMessageUtilsTestCase.assertSame((Object)"ident_ifier", (Object)JmsMessageUtils.encodeHeader((String)"ident_ifier"));
        JmsMessageUtilsTestCase.assertEquals((String)"_identifier", (String)JmsMessageUtils.encodeHeader((String)"-identifier"));
        JmsMessageUtilsTestCase.assertEquals((String)"identifier_", (String)JmsMessageUtils.encodeHeader((String)"identifier-"));
        JmsMessageUtilsTestCase.assertEquals((String)"ident_ifier", (String)JmsMessageUtils.encodeHeader((String)"ident-ifier"));
        JmsMessageUtilsTestCase.assertEquals((String)"_ident_ifier_", (String)JmsMessageUtils.encodeHeader((String)"-ident_ifier-"));
        JmsMessageUtilsTestCase.assertEquals((String)"_ident_ifier_", (String)JmsMessageUtils.encodeHeader((String)"-ident-ifier-"));
    }

    public void testTextMessageNullContent() throws Exception {
        Mock mockMessage = new Mock(TextMessage.class);
        mockMessage.expectAndReturn("getText", null);
        TextMessage mockTextMessage = (TextMessage)mockMessage.proxy();
        byte[] result = JmsMessageUtils.toByteArray((Message)mockTextMessage, (String)"1.0.2b");
        JmsMessageUtilsTestCase.assertNotNull((Object)result);
        JmsMessageUtilsTestCase.assertEquals((String)"Should return an empty byte array.", (int)0, (int)result.length);
        mockMessage.verify();
    }

    public void testByteMessageNullContent() throws Exception {
        Mock mockMessage = new Mock(BytesMessage.class);
        mockMessage.expect("reset");
        mockMessage.expectAndReturn("readBytes", (Object)new IsInstanceOf(byte[].class), -1);
        BytesMessage mockBytesMessage = (BytesMessage)mockMessage.proxy();
        byte[] result = JmsMessageUtils.toByteArray((Message)mockBytesMessage, (String)"1.0.2b");
        JmsMessageUtilsTestCase.assertNotNull((Object)result);
        JmsMessageUtilsTestCase.assertEquals((String)"Should return an empty byte array.", (int)0, (int)result.length);
        mockMessage.verify();
        mockMessage = new Mock(BytesMessage.class);
        mockMessage.expect("reset");
        mockMessage.expectAndReturn("getBodyLength", (Object)new Long(0L));
        mockBytesMessage = (BytesMessage)mockMessage.proxy();
        result = JmsMessageUtils.toByteArray((Message)mockBytesMessage, (String)"1.1");
        JmsMessageUtilsTestCase.assertNotNull((Object)result);
        JmsMessageUtilsTestCase.assertEquals((String)"Should return an empty byte array.", (int)0, (int)result.length);
        mockMessage.verify();
    }
}

