/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.issues;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import org.mule.api.MuleEventContext;
import org.mule.component.DefaultJavaComponent;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;
import org.mule.util.concurrent.Latch;

public class JmsReconnectionFunctionalMule1720TestCase
extends AbstractJmsFunctionalTestCase {
    private long RECONNECTION_TIMEOUT = 5000L;
    private Latch componentCallbackLatch;

    protected String getConfigResources() {
        return "providers/activemq/jms-reconnection-strategy.xml";
    }

    public void testReconnectionAfterConnectionFailure() throws Exception {
        this.componentCallbackLatch = new Latch();
        EventCallback callback = new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                JmsReconnectionFunctionalMule1720TestCase.this.componentCallbackLatch.countDown();
            }
        };
        DefaultJavaComponent defaultComponent = (DefaultJavaComponent)muleContext.getRegistry().lookupService("InputPart").getComponent();
        FunctionalTestComponent testComponent = (FunctionalTestComponent)defaultComponent.getObjectFactory().getInstance();
        testComponent.setEventCallback(callback);
        this.send(this.scenarioNoTx);
        JmsReconnectionFunctionalMule1720TestCase.assertTrue((boolean)this.componentCallbackLatch.await(1000L, TimeUnit.MILLISECONDS));
        this.componentCallbackLatch = new Latch();
        this.simulateConnectionFailure();
        Thread.sleep(this.RECONNECTION_TIMEOUT);
        this.send(this.scenarioNoTx);
        JmsReconnectionFunctionalMule1720TestCase.assertTrue((boolean)this.componentCallbackLatch.await(1000L, TimeUnit.MILLISECONDS));
    }

    private void simulateConnectionFailure() throws Exception {
        JmsConnector connector = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsConnector");
        connector.getConnection().getExceptionListener().onException(new JMSException("fake disconnect!"));
    }
}

