/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.text.MessageFormat;
import java.util.HashMap;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.XAConnectionFactory;
import javax.naming.NamingException;
import org.apache.commons.lang.UnhandledException;
import org.mule.api.MessagingException;
import org.mule.api.MuleException;
import org.mule.api.config.ExceptionReader;
import org.mule.api.context.notification.ConnectionNotificationListener;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.StartException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.service.Service;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.api.transport.Connectable;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.ReplyToHandler;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.NotificationException;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.AbstractConnector;
import org.mule.transport.ConnectException;
import org.mule.transport.FatalConnectException;
import org.mule.transport.jms.DefaultJmsTopicResolver;
import org.mule.transport.jms.DefaultRedeliveryHandlerFactory;
import org.mule.transport.jms.Jms102bSupport;
import org.mule.transport.jms.Jms11Support;
import org.mule.transport.jms.JmsExceptionReader;
import org.mule.transport.jms.JmsMessageAdapter;
import org.mule.transport.jms.JmsReplyToHandler;
import org.mule.transport.jms.JmsSupport;
import org.mule.transport.jms.JmsTopicResolver;
import org.mule.transport.jms.RedeliveryHandlerFactory;
import org.mule.transport.jms.i18n.JmsMessages;
import org.mule.transport.jms.xa.ConnectionFactoryWrapper;

public class JmsConnector
extends AbstractConnector
implements ConnectionNotificationListener {
    public static final String JMS = "jms";
    private int acknowledgementMode = 1;
    private String clientId;
    private boolean durable;
    private boolean noLocal;
    private boolean persistentDelivery;
    private boolean honorQosHeaders;
    private int maxRedelivery = 0;
    private boolean cacheJmsSessions = false;
    private boolean recoverJmsConnections = true;
    private boolean eagerConsumer = true;
    private ConnectionFactory connectionFactory;
    public String username = null;
    public String password = null;
    private Connection connection;
    private String specification = "1.0.2b";
    private JmsSupport jmsSupport;
    private JmsTopicResolver topicResolver;
    private RedeliveryHandlerFactory redeliveryHandlerFactory;

    public String getProtocol() {
        return JMS;
    }

    protected void doInitialise() throws InitialisationException {
        if (this.connectionFactory == null) {
            this.connectionFactory = this.getDefaultConnectionFactory();
        }
        if (this.connectionFactory == null) {
            throw new InitialisationException(JmsMessages.noConnectionFactorySet(), (Initialisable)this);
        }
        if (this.topicResolver == null) {
            this.topicResolver = new DefaultJmsTopicResolver(this);
        }
        if (this.redeliveryHandlerFactory == null) {
            this.redeliveryHandlerFactory = new DefaultRedeliveryHandlerFactory();
        }
        try {
            this.muleContext.registerListener((ServerNotificationListener)this, this.getName());
        }
        catch (NotificationException nex) {
            throw new InitialisationException((Throwable)nex, (Initialisable)this);
        }
    }

    protected ConnectionFactory getDefaultConnectionFactory() {
        return null;
    }

    protected void doDispose() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                this.logger.error((Object)"Jms connector failed to dispose properly: ", (Throwable)e);
            }
            this.connection = null;
        }
    }

    protected Connection createConnection() throws NamingException, JMSException, InitialisationException {
        ConnectionFactory cf = this.connectionFactory;
        try {
            if (cf instanceof XAConnectionFactory && this.muleContext.getTransactionManager() != null) {
                cf = new ConnectionFactoryWrapper(cf);
            }
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        if (cf == null) {
            throw new InitialisationException(JmsMessages.noConnectionFactorySet(), (Initialisable)this);
        }
        Connection connection = this.username != null ? this.jmsSupport.createConnection(cf, this.username, this.password) : this.jmsSupport.createConnection(cf);
        if (this.clientId != null) {
            connection.setClientID(this.getClientId());
        }
        if (this.recoverJmsConnections && this.connectionStrategy != null && connection != null) {
            connection.setExceptionListener(new ExceptionListener(){

                public void onException(JMSException jmsException) {
                    JmsConnector.this.logger.debug((Object)"About to recycle myself due to remote JMS connection shutdown.");
                    JmsConnector jmsConnector = JmsConnector.this;
                    try {
                        jmsConnector.stop();
                        jmsConnector.initialised.set(false);
                    }
                    catch (MuleException e) {
                        JmsConnector.this.logger.warn((Object)e.getMessage(), (Throwable)e);
                    }
                    try {
                        JmsConnector.this.connectionStrategy.connect((Connectable)jmsConnector);
                        HashMap receivers = new HashMap(jmsConnector.getReceivers());
                        jmsConnector.initialise();
                        for (MessageReceiver receiver : receivers.values()) {
                            try {
                                jmsConnector.registerListener(receiver.getService(), receiver.getEndpoint());
                            }
                            catch (Exception ex) {
                                throw new FatalConnectException((Throwable)ex, (Connectable)receiver);
                            }
                        }
                        jmsConnector.start();
                    }
                    catch (FatalConnectException fcex) {
                        JmsConnector.this.logger.fatal((Object)"Failed to reconnect to JMS server. I'm giving up.");
                    }
                    catch (MuleException umoex) {
                        throw new UnhandledException("Failed to recover a connector.", (Throwable)umoex);
                    }
                }
            });
        }
        return connection;
    }

    protected void doConnect() throws ConnectException {
        try {
            if (this.jmsSupport == null) {
                this.jmsSupport = "1.0.2b".equals(this.specification) ? new Jms102bSupport(this) : new Jms11Support(this);
            }
        }
        catch (Exception e) {
            throw new ConnectException(CoreMessages.failedToCreate((String)"Jms Connector"), (Throwable)e, (Connectable)this);
        }
        try {
            this.connection = this.createConnection();
            if (this.started.get()) {
                this.connection.start();
            }
        }
        catch (Exception e) {
            throw new ConnectException((Throwable)e, (Connectable)this);
        }
    }

    protected void doDisconnect() throws ConnectException {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception e) {
            throw new ConnectException((Throwable)e, (Connectable)this);
        }
        finally {
            this.connection = null;
        }
    }

    public MessageAdapter getMessageAdapter(Object message) throws MessagingException {
        JmsMessageAdapter adapter = (JmsMessageAdapter)super.getMessageAdapter(message);
        adapter.setSpecification(this.getSpecification());
        return adapter;
    }

    protected Object getReceiverKey(Service service, InboundEndpoint endpoint) {
        return service.getName() + "~" + endpoint.getEndpointURI().getAddress();
    }

    public Session getSessionFromTransaction() {
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (tx != null && tx.hasResource((Object)this.connection)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieving jms session from current transaction " + tx));
            }
            Session session = (Session)tx.getResource((Object)this.connection);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using " + session + " bound to transaction " + tx));
            }
            return session;
        }
        return null;
    }

    public Session getSession(ImmutableEndpoint endpoint) throws JMSException {
        boolean topic = this.getTopicResolver().isTopic(endpoint);
        return this.getSession(endpoint.getTransactionConfig().isTransacted(), topic);
    }

    public Session getSession(boolean transacted, boolean topic) throws JMSException {
        if (!this.isConnected()) {
            throw new JMSException("Not connected");
        }
        Session session = this.getSessionFromTransaction();
        if (session != null) {
            return session;
        }
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)MessageFormat.format("Retrieving new jms session from connection: topic={0}, transacted={1}, ack mode={2}, nolocal={3}", topic, transacted, new Integer(this.acknowledgementMode), this.noLocal));
        }
        session = this.jmsSupport.createSession(this.connection, topic, transacted, this.acknowledgementMode, this.noLocal);
        if (tx != null) {
            this.logger.debug((Object)("Binding session " + session + " to current transaction " + tx));
            try {
                tx.bindResource((Object)this.connection, (Object)session);
            }
            catch (TransactionException e) {
                this.closeQuietly(session);
                throw new RuntimeException("Could not bind session to current transaction", e);
            }
        }
        return session;
    }

    protected void doStart() throws MuleException {
        if (this.connection != null) {
            try {
                this.connection.start();
            }
            catch (JMSException e) {
                throw new StartException(CoreMessages.failedToStart((String)"Jms Connection"), (Throwable)e, (Startable)this);
            }
        }
    }

    protected void doStop() throws MuleException {
    }

    public ReplyToHandler getReplyToHandler() {
        return new JmsReplyToHandler(this, this.getDefaultResponseTransformers());
    }

    public void onNotification(ServerNotification notification) {
        if (notification.getAction() == 703 || notification.getAction() == 702) {
            this.disposeDispatchers();
        }
    }

    public boolean supportsProperty(String property) {
        return true;
    }

    public Message preProcessMessage(Message message, Session session) throws Exception {
        return message;
    }

    public void close(MessageProducer producer) throws JMSException {
        if (producer != null) {
            producer.close();
        }
    }

    public void closeQuietly(MessageProducer producer) {
        try {
            this.close(producer);
        }
        catch (JMSException e) {
            this.logger.error((Object)"Failed to close jms message producer", (Throwable)e);
        }
    }

    public void close(MessageConsumer consumer) throws JMSException {
        if (consumer != null) {
            consumer.close();
        }
    }

    public void closeQuietly(MessageConsumer consumer) {
        try {
            this.close(consumer);
        }
        catch (JMSException e) {
            this.logger.error((Object)"Failed to close jms message consumer", (Throwable)e);
        }
    }

    public void close(Session session) throws JMSException {
        if (session != null) {
            session.close();
        }
    }

    public void closeQuietly(Session session) {
        try {
            this.close(session);
        }
        catch (JMSException e) {
            this.logger.error((Object)"Failed to close jms session consumer", (Throwable)e);
        }
    }

    public void close(TemporaryQueue tempQueue) throws JMSException {
        if (tempQueue != null) {
            tempQueue.delete();
        }
    }

    public void closeQuietly(TemporaryQueue tempQueue) {
        block4: {
            try {
                this.close(tempQueue);
            }
            catch (JMSException e) {
                if (!this.logger.isErrorEnabled()) break block4;
                String queueName = "";
                try {
                    queueName = tempQueue.getQueueName();
                }
                catch (JMSException innerEx) {
                    // empty catch block
                }
                this.logger.info((Object)MessageFormat.format("Faled to delete a temporary queue '{0}' Reason: {1}", queueName, e.getMessage()));
            }
        }
    }

    public void close(TemporaryTopic tempTopic) throws JMSException {
        if (tempTopic != null) {
            tempTopic.delete();
        }
    }

    public void closeQuietly(TemporaryTopic tempTopic) {
        block4: {
            try {
                this.close(tempTopic);
            }
            catch (JMSException e) {
                if (!this.logger.isErrorEnabled()) break block4;
                String topicName = "";
                try {
                    topicName = tempTopic.getTopicName();
                }
                catch (JMSException innerEx) {
                    // empty catch block
                }
                this.logger.error((Object)("Faled to delete a temporary topic " + topicName), (Throwable)e);
            }
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected void setConnection(Connection connection) {
        this.connection = connection;
    }

    public int getAcknowledgementMode() {
        return this.acknowledgementMode;
    }

    public void setAcknowledgementMode(int acknowledgementMode) {
        this.acknowledgementMode = acknowledgementMode;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public boolean isPersistentDelivery() {
        return this.persistentDelivery;
    }

    public void setPersistentDelivery(boolean persistentDelivery) {
        this.persistentDelivery = persistentDelivery;
    }

    public JmsSupport getJmsSupport() {
        return this.jmsSupport;
    }

    public void setJmsSupport(JmsSupport jmsSupport) {
        this.jmsSupport = jmsSupport;
    }

    public String getSpecification() {
        return this.specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    public void setRecoverJmsConnections(boolean recover) {
        this.recoverJmsConnections = recover;
    }

    public boolean isRecoverJmsConnections() {
        return this.recoverJmsConnections;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public int getMaxRedelivery() {
        return this.maxRedelivery;
    }

    public void setMaxRedelivery(int maxRedelivery) {
        this.maxRedelivery = maxRedelivery;
    }

    public boolean isRemoteSyncEnabled() {
        return true;
    }

    public JmsTopicResolver getTopicResolver() {
        return this.topicResolver;
    }

    public void setTopicResolver(JmsTopicResolver topicResolver) {
        this.topicResolver = topicResolver;
    }

    public boolean isEagerConsumer() {
        return this.eagerConsumer;
    }

    public void setEagerConsumer(boolean eagerConsumer) {
        this.eagerConsumer = eagerConsumer;
    }

    public boolean isCacheJmsSessions() {
        return this.cacheJmsSessions;
    }

    public void setCacheJmsSessions(boolean cacheJmsSessions) {
        this.cacheJmsSessions = cacheJmsSessions;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public RedeliveryHandlerFactory getRedeliveryHandlerFactory() {
        return this.redeliveryHandlerFactory;
    }

    public void setRedeliveryHandlerFactory(RedeliveryHandlerFactory redeliveryHandlerFactory) {
        this.redeliveryHandlerFactory = redeliveryHandlerFactory;
    }

    public void setHonorQosHeaders(boolean honorQosHeaders) {
        this.honorQosHeaders = honorQosHeaders;
    }

    public boolean isHonorQosHeaders() {
        return this.honorQosHeaders;
    }

    static {
        ExceptionHelper.registerExceptionReader((ExceptionReader)new JmsExceptionReader());
    }
}

